/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.mime;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.mailbox.store.search.mime.EMailer;
import org.apache.james.mailbox.store.search.mime.SerializableMessage;

public class EMailers
implements SerializableMessage {
    private final Set<EMailer> emailers;

    public static EMailers from(Set<EMailer> emailers) {
        Preconditions.checkNotNull(emailers, (Object)"'emailers' is mandatory");
        return new EMailers(emailers);
    }

    private EMailers(Set<EMailer> emailers) {
        this.emailers = emailers;
    }

    public Set<EMailer> getEmailers() {
        return this.emailers;
    }

    @Override
    public String serialize() {
        return this.emailers.stream().map(EMailer::serialize).collect(Collectors.joining(" "));
    }
}

