/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.CryptoAlgorithm;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.KeyException;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import io.jsonwebtoken.security.VerifySecureDigestRequest;
import java.io.InputStream;
import java.security.Key;

abstract class AbstractSecureDigestAlgorithm<S extends Key, V extends Key>
extends CryptoAlgorithm
implements SecureDigestAlgorithm<S, V> {
    AbstractSecureDigestAlgorithm(String id, String jcaName) {
        super(id, jcaName);
    }

    protected static String keyType(boolean signing) {
        return signing ? "signing" : "verification";
    }

    protected abstract void validateKey(Key var1, boolean var2);

    public final byte[] digest(SecureRequest<InputStream, S> request) throws SecurityException {
        Assert.notNull(request, (String)"Request cannot be null.");
        Key key = (Key)Assert.notNull((Object)request.getKey(), (String)"Signing key cannot be null.");
        Assert.notNull((Object)request.getPayload(), (String)"Request content cannot be null.");
        try {
            this.validateKey(key, true);
            return this.doDigest(request);
        }
        catch (KeyException | SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to compute " + this.getId() + " signature with JCA algorithm '" + this.getJcaName() + "' " + "using key {" + KeysBridge.toString(key) + "}: " + e.getMessage();
            throw new SignatureException(msg, (Throwable)e);
        }
    }

    protected abstract byte[] doDigest(SecureRequest<InputStream, S> var1) throws Exception;

    public final boolean verify(VerifySecureDigestRequest<V> request) throws SecurityException {
        Assert.notNull(request, (String)"Request cannot be null.");
        Key key = (Key)Assert.notNull((Object)request.getKey(), (String)"Verification key cannot be null.");
        Assert.notNull((Object)request.getPayload(), (String)"Request content cannot be null or empty.");
        Assert.notEmpty((byte[])request.getDigest(), (String)"Request signature byte array cannot be null or empty.");
        try {
            this.validateKey(key, false);
            return this.doVerify(request);
        }
        catch (KeyException | SignatureException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to verify " + this.getId() + " signature with JCA algorithm '" + this.getJcaName() + "' " + "using key {" + KeysBridge.toString(key) + "}: " + e.getMessage();
            throw new SignatureException(msg, (Throwable)e);
        }
    }

    protected abstract boolean doVerify(VerifySecureDigestRequest<V> var1);
}

