/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.EntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class TextFormattedEntryRebalancingRequestAccessLogMessage
extends TextFormattedAccessLogMessage
implements EntryRebalancingRequestAccessLogMessage {
    private static final long serialVersionUID = 2987012037535137130L;
    @Nullable
    private final Integer sizeLimit;
    @Nullable
    private final Long rebalancingOperationID = this.getLongNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_OPERATION_ID);
    @Nullable
    private final Long triggeredByConnectionID = this.getLongNoThrow(TextFormattedAccessLogFields.TRIGGERED_BY_CONNECTION_ID);
    @Nullable
    private final Long triggeredByOperationID = this.getLongNoThrow(TextFormattedAccessLogFields.TRIGGERED_BY_OPERATION_ID);
    @Nullable
    private final String sourceBackendServer;
    @Nullable
    private final String sourceBackendSetName;
    @Nullable
    private final String subtreeBaseDN = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_BASE_DN);
    @Nullable
    private final String targetBackendServer;
    @Nullable
    private final String targetBackendSetName;

    public TextFormattedEntryRebalancingRequestAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedEntryRebalancingRequestAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.sizeLimit = this.getIntegerNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_SIZE_LIMIT);
        this.sourceBackendSetName = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_BACKEND_SET);
        this.sourceBackendServer = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_SERVER);
        this.targetBackendSetName = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_TARGET_BACKEND_SET);
        this.targetBackendServer = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_TARGET_SERVER);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY_REBALANCING_REQUEST;
    }

    @Override
    @Nullable
    public final Long getRebalancingOperationID() {
        return this.rebalancingOperationID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByConnectionID() {
        return this.triggeredByConnectionID;
    }

    @Override
    @Nullable
    public final Long getTriggeredByOperationID() {
        return this.triggeredByOperationID;
    }

    @Override
    @Nullable
    public final String getSubtreeBaseDN() {
        return this.subtreeBaseDN;
    }

    @Override
    @Nullable
    public final Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    @Nullable
    public final String getSourceBackendSetName() {
        return this.sourceBackendSetName;
    }

    @Override
    @Nullable
    public final String getSourceBackendServer() {
        return this.sourceBackendServer;
    }

    @Override
    @Nullable
    public final String getTargetBackendSetName() {
        return this.targetBackendSetName;
    }

    @Override
    @Nullable
    public final String getTargetBackendServer() {
        return this.targetBackendServer;
    }
}

