/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.opensearch.client.Message;
import org.opensearch.client.ResponseException;
import org.opensearch.client.ResponseWarningsExtractor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StreamingResponse<T> {
    private final RequestLine requestLine;
    private final Mono<Message<HttpResponse, Publisher<T>>> publisher;
    private volatile HttpHost host;

    public StreamingResponse(RequestLine requestLine, Publisher<Message<HttpResponse, Publisher<T>>> publisher) {
        this.requestLine = requestLine;
        this.publisher = Mono.from(publisher).cache();
    }

    public void setHost(HttpHost host) {
        this.host = host;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public Publisher<T> getBody() {
        return this.publisher.flatMapMany(m -> Flux.from((Publisher)((Publisher)m.getBody())));
    }

    public StatusLine getStatusLine() {
        return (StatusLine)this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just((Object)e.getResponse().getHttpResponse())).map(HttpResponse::getStatusLine).block();
    }

    public List<String> getWarnings() {
        return ResponseWarningsExtractor.getWarnings((HttpResponse)this.publisher.map(Message::getHead).onErrorResume(ResponseException.class, e -> Mono.just((Object)e.getResponse().getHttpResponse())).block());
    }
}

