/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.search;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UidSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    public UidSearchOverride(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return searchQuery.getCriteria().size() == 1 && searchQuery.getCriteria().get(0) instanceof SearchQuery.UidCriterion && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        SearchQuery.UidCriterion uidArgument = searchQuery.getCriteria().stream().filter(criterion -> criterion instanceof SearchQuery.UidCriterion).map(SearchQuery.UidCriterion.class::cast).findAny().orElseThrow(() -> new RuntimeException("Missing Uid argument"));
        SearchQuery.UidRange[] uidRanges = uidArgument.getOperator().getRange();
        return Mono.fromCallable(() -> new PostgresMailboxMessageDAO(this.executorFactory.create(session.getUser().getDomainPart()))).flatMapMany(dao -> Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])uidRanges)).concatMap(range -> dao.listUids((PostgresMailboxId)mailbox.getMailboxId(), MessageRange.range((MessageUid)range.getLowValue(), (MessageUid)range.getHighValue()))));
    }
}

