/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import com.github.f4b6a3.uuid.UuidCreator;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.UUID;
import org.apache.james.mailbox.model.MessageId;

public class PostgresMessageId
implements MessageId {
    private final UUID uuid;

    private PostgresMessageId(UUID uuid) {
        this.uuid = uuid;
    }

    public String serialize() {
        return this.uuid.toString();
    }

    public UUID asUuid() {
        return this.uuid;
    }

    public boolean isSerializable() {
        return true;
    }

    public final boolean equals(Object o) {
        if (o instanceof PostgresMessageId) {
            PostgresMessageId other = (PostgresMessageId)o;
            return Objects.equals(this.uuid, other.uuid);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.uuid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uuid", (Object)this.uuid).toString();
    }

    public static class Factory
    implements MessageId.Factory {
        public PostgresMessageId generate() {
            return Factory.of(UuidCreator.getTimeOrderedEpoch());
        }

        public static PostgresMessageId of(UUID uuid) {
            return new PostgresMessageId(uuid);
        }

        public PostgresMessageId fromString(String serialized) {
            return Factory.of(UUID.fromString(serialized));
        }
    }
}

