/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public class RoutingKey {
    @NonNull
    public static ByteBuffer compose(ByteBuffer ... components) {
        if (components.length == 1) {
            return components[0];
        }
        int totalLength = 0;
        for (ByteBuffer bb : components) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : components) {
            ByteBuffer bb = buffer.duplicate();
            RoutingKey.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }
}

