/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.IndexKind;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultIndexMetadata
implements IndexMetadata,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final CqlIdentifier keyspace;
    @NonNull
    private final CqlIdentifier table;
    @NonNull
    private final CqlIdentifier name;
    @NonNull
    private final IndexKind kind;
    @NonNull
    private final String target;
    @NonNull
    private final Map<String, String> options;

    public DefaultIndexMetadata(@NonNull CqlIdentifier keyspace, @NonNull CqlIdentifier table, @NonNull CqlIdentifier name, @NonNull IndexKind kind, @NonNull String target, @NonNull Map<String, String> options) {
        this.keyspace = keyspace;
        this.table = table;
        this.name = name;
        this.kind = kind;
        this.target = target;
        this.options = options;
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    @NonNull
    public IndexKind getKind() {
        return this.kind;
    }

    @Override
    @NonNull
    public String getTarget() {
        return this.target;
    }

    @Override
    @NonNull
    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IndexMetadata) {
            IndexMetadata that = (IndexMetadata)other;
            return Objects.equals(this.keyspace, that.getKeyspace()) && Objects.equals(this.table, that.getTable()) && Objects.equals(this.name, that.getName()) && Objects.equals((Object)this.kind, (Object)that.getKind()) && Objects.equals(this.target, that.getTarget()) && Objects.equals(this.options, that.getOptions());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyspace, this.table, this.name, this.kind, this.target, this.options});
    }

    public String toString() {
        return "DefaultIndexMetadata@" + Integer.toHexString(this.hashCode()) + "(" + this.keyspace.asInternal() + "." + this.table.asInternal() + "." + this.name.asInternal() + ")";
    }
}

