/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public interface FunctionMetadata
extends Describable {
    @NonNull
    public CqlIdentifier getKeyspace();

    @NonNull
    public FunctionSignature getSignature();

    @NonNull
    public List<CqlIdentifier> getParameterNames();

    @NonNull
    public String getBody();

    public boolean isCalledOnNullInput();

    @NonNull
    public String getLanguage();

    @NonNull
    public DataType getReturnType();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        builder.append("CREATE FUNCTION ").append(this.getKeyspace()).append(".").append(this.getSignature().getName()).append("(");
        boolean first = true;
        for (int i = 0; i < this.getSignature().getParameterTypes().size(); ++i) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            DataType type = this.getSignature().getParameterTypes().get(i);
            CqlIdentifier name = this.getParameterNames().get(i);
            builder.append(name).append(" ").append(type.asCql(false, pretty));
        }
        return builder.append(")").increaseIndent().newLine().append(this.isCalledOnNullInput() ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT").newLine().append("RETURNS ").append(this.getReturnType().asCql(false, true)).newLine().append("LANGUAGE ").append(this.getLanguage()).newLine().append("AS '").append(this.getBody()).append("';").build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        return this.describe(pretty);
    }
}

