/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.postgres;

import java.time.LocalDateTime;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresVacationDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresVacationResponseTable.TABLE}).addTable(new PostgresTable[]{PostgresVacationNotificationRegistryTable.TABLE}).addIndex(new PostgresIndex[]{PostgresVacationNotificationRegistryTable.ACCOUNT_ID_INDEX, PostgresVacationNotificationRegistryTable.FULL_COMPOSITE_INDEX}).build();

    public static interface PostgresVacationResponseTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"vacation_response");
        public static final Field<String> ACCOUNT_ID = DSL.field((String)"account_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<Boolean> IS_ENABLED = DSL.field((String)"is_enabled", (DataType)SQLDataType.BOOLEAN.notNull().defaultValue(DSL.field((String)"false", (DataType)SQLDataType.BOOLEAN)));
        public static final Field<LocalDateTime> FROM_DATE = DSL.field((String)"from_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP);
        public static final Field<LocalDateTime> TO_DATE = DSL.field((String)"to_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP);
        public static final Field<String> TEXT = DSL.field((String)"text", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> SUBJECT = DSL.field((String)"subject", (DataType)SQLDataType.VARCHAR);
        public static final Field<String> HTML = DSL.field((String)"html", (DataType)SQLDataType.VARCHAR);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(ACCOUNT_ID).column(IS_ENABLED).column(FROM_DATE).column(TO_DATE).column(TEXT).column(SUBJECT).column(HTML).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{ACCOUNT_ID}))).supportsRowLevelSecurity().build();
    }

    public static interface PostgresVacationNotificationRegistryTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"vacation_notification_registry");
        public static final Field<String> ACCOUNT_ID = DSL.field((String)"account_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<String> RECIPIENT_ID = DSL.field((String)"recipient_id", (DataType)SQLDataType.VARCHAR.notNull());
        public static final Field<LocalDateTime> EXPIRY_DATE = DSL.field((String)"expiry_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP);
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(ACCOUNT_ID).column(RECIPIENT_ID).column(EXPIRY_DATE).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{ACCOUNT_ID, RECIPIENT_ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex ACCOUNT_ID_INDEX = PostgresIndex.name((String)"vacation_notification_registry_accountid_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{ACCOUNT_ID}));
        public static final PostgresIndex FULL_COMPOSITE_INDEX = PostgresIndex.name((String)"vnr_accountid_recipientid_expirydate_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{ACCOUNT_ID, RECIPIENT_ID, EXPIRY_DATE}));
    }
}

