/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Strings;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class SetMimeHeader
extends GenericMailet {
    private String headerName;
    private String headerValue;

    public void init() throws MessagingException {
        this.headerName = this.getInitParameter("name");
        this.headerValue = this.getInitParameter("value");
        if (Strings.isNullOrEmpty((String)this.headerName) || Strings.isNullOrEmpty((String)this.headerValue)) {
            throw new MessagingException("Please configure a name and a value");
        }
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        message.addHeader(this.headerName, this.headerValue);
        message.saveChanges();
    }

    public String getMailetInfo() {
        return "SetMimeHeader Mailet";
    }
}

