/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbConfig;
import jakarta.json.spi.JsonProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.InstanceCreator;
import org.eclipse.yasson.internal.JsonbConfigProperties;
import org.eclipse.yasson.internal.MappingContext;
import org.eclipse.yasson.internal.components.JsonbComponentInstanceCreatorFactory;
import org.eclipse.yasson.spi.JsonbComponentInstanceCreator;

public class JsonbContext {
    private static final Logger LOGGER = Logger.getLogger(JsonbContext.class.getName());
    private final JsonbConfig jsonbConfig;
    private final MappingContext mappingContext;
    private final JsonbComponentInstanceCreator componentInstanceCreator;
    private final JsonProvider jsonProvider;
    private final ComponentMatcher componentMatcher;
    private final AnnotationIntrospector annotationIntrospector;
    private final JsonbConfigProperties configProperties;
    private final InstanceCreator instanceCreator;

    public JsonbContext(JsonbConfig jsonbConfig, JsonProvider jsonProvider) {
        Objects.requireNonNull(jsonbConfig);
        this.jsonbConfig = jsonbConfig;
        this.mappingContext = new MappingContext(this);
        this.instanceCreator = InstanceCreator.getSingleton();
        this.componentInstanceCreator = this.initComponentInstanceCreator(this.instanceCreator);
        this.componentMatcher = new ComponentMatcher(this);
        this.annotationIntrospector = new AnnotationIntrospector(this);
        this.jsonProvider = jsonProvider;
        this.configProperties = new JsonbConfigProperties(jsonbConfig);
    }

    public JsonbConfig getConfig() {
        return this.jsonbConfig;
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public JsonbComponentInstanceCreator getComponentInstanceCreator() {
        return this.componentInstanceCreator;
    }

    public ComponentMatcher getComponentMatcher() {
        return this.componentMatcher;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this.annotationIntrospector;
    }

    public JsonbConfigProperties getConfigProperties() {
        return this.configProperties;
    }

    public InstanceCreator getInstanceCreator() {
        return this.instanceCreator;
    }

    private JsonbComponentInstanceCreator initComponentInstanceCreator(InstanceCreator instanceCreator) {
        ServiceLoader loader = AccessController.doPrivileged(() -> ServiceLoader.load(JsonbComponentInstanceCreator.class));
        ArrayList<JsonbComponentInstanceCreator> creators = new ArrayList<JsonbComponentInstanceCreator>();
        for (JsonbComponentInstanceCreator creator : loader) {
            creators.add(creator);
        }
        if (creators.isEmpty()) {
            return JsonbComponentInstanceCreatorFactory.getComponentInstanceCreator(instanceCreator);
        }
        creators.sort(Comparator.comparingInt(JsonbComponentInstanceCreator::getPriority).reversed());
        JsonbComponentInstanceCreator creator = (JsonbComponentInstanceCreator)creators.get(0);
        LOGGER.finest("Component instance creator:" + creator.getClass());
        return creator;
    }
}

