/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.cassandra;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.cassandra.CassandraUsersDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class CassandraDelegationStore
implements DelegationStore {
    private final CassandraUsersDAO cassandraUsersDAO;
    private final UserExistencePredicate userExistencePredicate;

    @Inject
    public CassandraDelegationStore(CassandraUsersDAO cassandraUsersDAO, UserExistencePredicate userExistencePredicate) {
        this.cassandraUsersDAO = cassandraUsersDAO;
        this.userExistencePredicate = userExistencePredicate;
    }

    public Publisher<Username> authorizedUsers(Username baseUser) {
        return this.cassandraUsersDAO.getAuthorizedUsers(baseUser);
    }

    public Publisher<Void> clear(Username baseUser) {
        return this.cassandraUsersDAO.removeAllAuthorizedUsers(baseUser);
    }

    public Publisher<Void> addAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.userExistencePredicate.exists(userWithAccess).flatMap(targetUserExists -> this.cassandraUsersDAO.addAuthorizedUsers(baseUser, userWithAccess, (boolean)targetUserExists));
    }

    public Publisher<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.cassandraUsersDAO.removeAuthorizedUser(baseUser, userWithAccess);
    }

    public Publisher<Username> delegatedUsers(Username baseUser) {
        return this.cassandraUsersDAO.getDelegatedToUsers(baseUser);
    }

    public Publisher<Void> removeDelegatedUser(Username baseUser, Username delegatedToUser) {
        return this.cassandraUsersDAO.removeDelegatedToUser(baseUser, delegatedToUser);
    }

    public static interface UserExistencePredicate {
        public Mono<Boolean> exists(Username var1);
    }

    public static class UserExistencePredicateImplementation
    implements UserExistencePredicate {
        private final UsersRepository usersRepository;

        @Inject
        UserExistencePredicateImplementation(UsersRepository usersRepository) {
            this.usersRepository = usersRepository;
        }

        @Override
        public Mono<Boolean> exists(Username username) {
            return Mono.from((Publisher)this.usersRepository.containsReactive(username));
        }
    }
}

