/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractName;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.Keywords;
import org.jooq.impl.PrimaryKeyConstraintImpl;
import org.jooq.impl.Tools;

abstract class AbstractConstraint
extends AbstractNamed
implements ConstraintEnforcementStep {
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONSTRAINT};
    static final Set<SQLDialect> NO_SUPPORT_NAMED = SQLDialect.supportedBy(new SQLDialect[0]);
    static final Set<SQLDialect> NO_SUPPORT_NAMED_PK = SQLDialect.supportedBy(SQLDialect.CLICKHOUSE);
    boolean enforced = true;

    AbstractConstraint() {
        this(null);
    }

    AbstractConstraint(Name name) {
        this(name, false);
    }

    AbstractConstraint(Name name, boolean enforced) {
        super(name, null);
        this.enforced = enforced;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean named;
        boolean bl = named = !this.getQualifiedName().equals(AbstractName.NO_NAME);
        if (named && Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_CONSTRAINT_REFERENCE))) {
            ctx.visit(this.getQualifiedName());
        } else {
            if (!(!named || NO_SUPPORT_NAMED.contains((Object)ctx.dialect()) || this instanceof PrimaryKeyConstraintImpl && NO_SUPPORT_NAMED_PK.contains((Object)ctx.dialect()))) {
                ctx.visit(Keywords.K_CONSTRAINT).sql(' ').visit(this.getUnqualifiedName()).sql(' ');
            }
            this.accept0(ctx);
            if (!this.enforced) {
                AbstractConstraint.acceptEnforced(ctx, this.enforced);
            }
        }
    }

    abstract void accept0(Context<?> var1);

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    static void acceptEnforced(Context<?> ctx, boolean enforced) {
        switch (ctx.family()) {
            default: 
        }
        if (enforced) {
            ctx.sql(' ').visit(Keywords.K_ENFORCED);
        } else {
            ctx.sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ENFORCED);
        }
    }

    abstract boolean supported(Context<?> var1, Table<?> var2);

    @Override
    public final AbstractConstraint enforced() {
        this.enforced = true;
        return this;
    }

    @Override
    public final AbstractConstraint notEnforced() {
        this.enforced = false;
        return this;
    }

    public final boolean $enforced() {
        return this.enforced;
    }
}

