/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;

public interface JmapChange {
    public AccountId getAccountId();

    public JmapChange forSharee(AccountId var1, Supplier<State> var2);

    public boolean isNoop();

    default public ImmutableList<JmapChange> propagateToSharee(List<AccountId> sharees, State.Factory stateFactory) {
        if (this.isNoop()) {
            return ImmutableList.of();
        }
        return (ImmutableList)Stream.concat(Stream.of(this), sharees.stream().map(shareeId -> this.forSharee((AccountId)shareeId, stateFactory::generate))).collect(ImmutableList.toImmutableList());
    }
}

