/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum PassphraseEncryptionCipherType {
    AES_128("AES/CBC/PKCS5Padding", 128, "PBKDF2WithHmacSHA1", PassphraseEncryptedOutputStream.DEFAULT_AES_128_CIPHER_TYPE_ITERATION_COUNT, 16, 16, "HmacSHA256"),
    AES_256("AES/CBC/PKCS5Padding", 256, "PBKDF2WithHmacSHA512", PassphraseEncryptedOutputStream.DEFAULT_AES_256_CIPHER_TYPE_ITERATION_COUNT, 16, 16, "HmacSHA512");

    @NotNull
    private static final AtomicReference<PassphraseEncryptionCipherType> STRONGEST_AVAILABLE_CIPHER_TYPE;
    private final int initializationVectorLengthBytes;
    private final int keyFactoryIterationCount;
    private final int keyFactorySaltLengthBytes;
    private final int keyLengthBits;
    @NotNull
    private final String cipherTransformation;
    @NotNull
    private final String keyFactoryAlgorithm;
    @NotNull
    private final String macAlgorithm;

    private PassphraseEncryptionCipherType(@NotNull String cipherTransformation, int keyLengthBits, String keyFactoryAlgorithm, int keyFactoryIterationCount, @NotNull int keyFactorySaltLengthBytes, int initializationVectorLengthBytes, String macAlgorithm) {
        this.cipherTransformation = cipherTransformation;
        this.keyLengthBits = keyLengthBits;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.keyFactoryIterationCount = keyFactoryIterationCount;
        this.keyFactorySaltLengthBytes = keyFactorySaltLengthBytes;
        this.initializationVectorLengthBytes = initializationVectorLengthBytes;
        this.macAlgorithm = macAlgorithm;
    }

    @NotNull
    public String getCipherTransformation() {
        return this.cipherTransformation;
    }

    public int getKeyLengthBits() {
        return this.keyLengthBits;
    }

    @NotNull
    public String getKeyFactoryAlgorithm() {
        return this.keyFactoryAlgorithm;
    }

    public int getKeyFactoryIterationCount() {
        return this.keyFactoryIterationCount;
    }

    public int getKeyFactorySaltLengthBytes() {
        return this.keyFactorySaltLengthBytes;
    }

    public int getInitializationVectorLengthBytes() {
        return this.initializationVectorLengthBytes;
    }

    @NotNull
    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    @Nullable
    public static PassphraseEncryptionCipherType forName(@NotNull String name) {
        String transformedName = StaticUtils.toUpperCase(name).replace('-', '_');
        for (PassphraseEncryptionCipherType value : PassphraseEncryptionCipherType.values()) {
            if (!value.name().equals(transformedName)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public static PassphraseEncryptionCipherType getStrongestAvailableCipherType() {
        PassphraseEncryptionCipherType cipherType = STRONGEST_AVAILABLE_CIPHER_TYPE.get();
        if (cipherType == null) {
            cipherType = AES_128;
            try {
                PassphraseEncryptionCipherType ct = AES_256;
                PassphraseEncryptedStreamHeader header = new PassphraseEncryptedStreamHeader("dummy-passphrase".toCharArray(), ct.getKeyFactoryAlgorithm(), ct.getKeyFactoryIterationCount(), new byte[ct.getKeyFactorySaltLengthBytes()], ct.getKeyLengthBits(), ct.getCipherTransformation(), new byte[ct.getInitializationVectorLengthBytes()], null, ct.getMacAlgorithm());
                header.createCipher(1);
                cipherType = ct;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            if (!STRONGEST_AVAILABLE_CIPHER_TYPE.compareAndSet(null, cipherType)) {
                cipherType = STRONGEST_AVAILABLE_CIPHER_TYPE.get();
            }
        }
        return cipherType;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PassphraseEncryptedCipherType(cipherTransformation='");
        buffer.append(this.cipherTransformation);
        buffer.append("', keyLengthBits=");
        buffer.append(this.keyLengthBits);
        buffer.append(", keyFactoryAlgorithm='");
        buffer.append(this.keyFactoryAlgorithm);
        buffer.append("', keyFactoryIterationCount=");
        buffer.append(this.keyFactoryIterationCount);
        buffer.append(", keyFactorySaltLengthBytes=");
        buffer.append(this.keyFactorySaltLengthBytes);
        buffer.append(", initializationVectorLengthBytes=");
        buffer.append(this.initializationVectorLengthBytes);
        buffer.append(", macAlgorithm='");
        buffer.append(this.macAlgorithm);
        buffer.append("')");
    }

    static {
        STRONGEST_AVAILABLE_CIPHER_TYPE = new AtomicReference();
    }
}

