/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayInputStream;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtil {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SSL_HANDLER_NAME = "ssl";

    public static String getCertSubjectDN(RemotingConnection connection) {
        String certSubjectDN = "unavailable";
        X509Certificate[] certs = CertificateUtil.getCertsFromConnection(connection);
        if (certs != null && certs.length > 0 && certs[0] != null) {
            certSubjectDN = certs[0].getSubjectDN().getName();
        }
        return certSubjectDN;
    }

    public static X509Certificate[] getCertsFromConnection(RemotingConnection remotingConnection) {
        Connection transportConnection;
        X509Certificate[] certificates = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection) {
            NettyConnection nettyConnection = (NettyConnection)transportConnection;
            certificates = CertificateUtil.getCertsFromChannel(nettyConnection.getChannel());
        }
        return certificates;
    }

    public static Principal getPeerPrincipalFromConnection(RemotingConnection remotingConnection) {
        NettyConnection nettyConnection;
        ChannelHandler channelHandler;
        Connection transportConnection;
        Principal result = null;
        if (remotingConnection != null && (transportConnection = remotingConnection.getTransportConnection()) instanceof NettyConnection && (channelHandler = (nettyConnection = (NettyConnection)transportConnection).getChannel().pipeline().get(SSL_HANDLER_NAME)) != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                result = sslHandler.engine().getSession().getPeerPrincipal();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Principal getLocalPrincipalFromConnection(NettyConnection nettyConnection) {
        Principal result = null;
        ChannelHandler handler = nettyConnection.getChannel().pipeline().get(SSL_HANDLER_NAME);
        if (handler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)handler;
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }

    private static X509Certificate[] getCertsFromChannel(Channel channel) {
        Certificate[] plainCerts = null;
        ChannelHandler channelHandler = channel.pipeline().get(SSL_HANDLER_NAME);
        if (channelHandler != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                plainCerts = sslHandler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        X509Certificate[] x509Certs = null;
        if (plainCerts != null && plainCerts.length > 0) {
            x509Certs = new X509Certificate[plainCerts.length];
            for (int i = 0; i < plainCerts.length; ++i) {
                Certificate certificate = plainCerts[i];
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate;
                    x509Certs[i] = x509Certificate = (X509Certificate)certificate;
                } else {
                    try {
                        x509Certs[i] = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(plainCerts[i].getEncoded()));
                    }
                    catch (Exception ex) {
                        logger.trace("Failed to convert SSL cert", (Throwable)ex);
                        return null;
                    }
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Cert #{} = {}", (Object)i, (Object)x509Certs[i]);
            }
        }
        return x509Certs;
    }
}

