/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;

public final class ActiveMQXAConnection
extends ActiveMQConnection
implements XATopicConnection,
XAQueueConnection {
    public ActiveMQXAConnection(ConnectionFactoryOptions options, String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, boolean cacheDestinations, boolean enable1xNaming, ClientSessionFactory sessionFactory) {
        super(options, username, password, connectionType, clientID, dupsOKBatchSize, transactionBatchSize, cacheDestinations, enable1xNaming, sessionFactory);
    }

    public synchronized XASession createXASession() throws JMSException {
        this.checkClosed();
        return (XASession)this.createSessionInternal(this.isXA(), true, 0, 0);
    }

    public synchronized XAQueueSession createXAQueueSession() throws JMSException {
        this.checkClosed();
        return (XAQueueSession)this.createSessionInternal(this.isXA(), true, 0, 1);
    }

    public synchronized XATopicSession createXATopicSession() throws JMSException {
        this.checkClosed();
        return (XATopicSession)this.createSessionInternal(this.isXA(), true, 0, 2);
    }

    @Override
    protected boolean isXA() {
        return true;
    }
}

