/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jpa.healthcheck;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JPAHealthCheck
implements HealthCheck {
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public JPAHealthCheck(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public ComponentName componentName() {
        return new ComponentName("JPA Backend");
    }

    public Mono<Result> check() {
        return Mono.usingWhen((Publisher)Mono.fromCallable(() -> ((EntityManagerFactory)this.entityManagerFactory).createEntityManager()).subscribeOn(Schedulers.boundedElastic()), entityManager -> {
            if (entityManager.isOpen()) {
                return Mono.just((Object)Result.healthy((ComponentName)this.componentName()));
            }
            return Mono.just((Object)Result.unhealthy((ComponentName)this.componentName(), (String)"entityManager is not open"));
        }, entityManager -> Mono.fromRunnable(() -> EntityManagerUtils.safelyClose((EntityManager)entityManager)).subscribeOn(Schedulers.boundedElastic())).onErrorResume(IllegalStateException.class, e -> Mono.just((Object)Result.unhealthy((ComponentName)this.componentName(), (String)"EntityManagerFactory or EntityManager thrown an IllegalStateException, the connection is unhealthy", (Throwable)e))).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)this.componentName(), (String)"Unexpected exception upon checking JPA driver", (Throwable)e)));
    }
}

