/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.condition.user;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Set;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.UserCondition;
import org.apache.james.webadmin.dto.MailboxResponse;
import org.apache.james.webadmin.service.UserMailboxesService;

public class HasNotAllSystemMailboxesCondition
implements UserCondition {
    public static final String HAS_NOT_ALL_SYSTEM_MAILBOXES_PARAM = "hasNotAllSystemMailboxes";
    private static final Set<String> DEFAULT_MAILBOX_SET = (Set)DefaultMailboxes.DEFAULT_MAILBOXES.stream().collect(ImmutableSet.toImmutableSet());
    private final UserMailboxesService userMailboxesService;

    @Inject
    public HasNotAllSystemMailboxesCondition(UserMailboxesService userMailboxesService) {
        this.userMailboxesService = userMailboxesService;
    }

    public boolean test(Username username) {
        try {
            Set mailboxes = (Set)this.userMailboxesService.listMailboxes(username, UserMailboxesService.Options.Force).stream().map(MailboxResponse::getMailboxName).collect(ImmutableSet.toImmutableSet());
            return !Sets.difference(DEFAULT_MAILBOX_SET, (Set)mailboxes).isEmpty();
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

