/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import jakarta.mail.internet.InternetHeaders;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;

public class InternetHeadersInputStream
extends InputStream {
    private static final String LINE_SEPERATOR = "\r\n";
    private final Enumeration<String> headerLines;
    private byte[] currLine;
    private int pos = 0;

    public InternetHeadersInputStream(InternetHeaders headers) {
        this(headers.getAllHeaderLines());
    }

    public InternetHeadersInputStream(Enumeration<String> headerLines) {
        this.headerLines = headerLines;
    }

    @Override
    public int read() {
        if (!(this.currLine != null && this.pos != this.currLine.length || this.readNextLine())) {
            return -1;
        }
        return this.currLine[this.pos++];
    }

    private boolean readNextLine() {
        if (this.headerLines.hasMoreElements()) {
            this.pos = 0;
            String line = this.headerLines.nextElement() + LINE_SEPERATOR;
            if (!this.headerLines.hasMoreElements()) {
                line = line + LINE_SEPERATOR;
            }
            this.currLine = line.getBytes(StandardCharsets.US_ASCII);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.currLine = null;
    }
}

