/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.backend;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.message.backend.BackendMessage;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;

public final class BackendKeyData
implements BackendMessage {
    private final int processId;
    private final int secretKey;

    public BackendKeyData(int processId, int secretKey) {
        this.processId = processId;
        this.secretKey = secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackendKeyData that = (BackendKeyData)o;
        return this.processId == that.processId && this.secretKey == that.secretKey;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getSecretKey() {
        return this.secretKey;
    }

    public int hashCode() {
        return Objects.hash(this.processId, this.secretKey);
    }

    public String toString() {
        return "BackendKeyData{processId=" + this.processId + ", secretKey=" + this.secretKey + '}';
    }

    static BackendKeyData decode(ByteBuf in) {
        Assert.requireNonNull(in, "in must not be null");
        return new BackendKeyData(in.readInt(), in.readInt());
    }
}

