/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractGeometryCodec;
import io.r2dbc.postgresql.codec.Line;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import java.util.ArrayList;

final class LineCodec
extends AbstractGeometryCodec<Line> {
    LineCodec(ByteBufAllocator byteBufAllocator) {
        super(Line.class, PostgresqlObjectId.LINE, byteBufAllocator);
    }

    @Override
    Line doDecodeBinary(ByteBuf byteBuffer) {
        return Line.of(byteBuffer.readDouble(), byteBuffer.readDouble(), byteBuffer.readDouble());
    }

    @Override
    Line doDecodeText(String text) {
        ArrayList list = new ArrayList();
        this.getTokenStream(text).forEachRemaining(e -> list.add(Double.parseDouble(e)));
        return list.size() == 3 ? Line.of((Double)list.get(0), (Double)list.get(1), (Double)list.get(2)) : Line.of((Double)list.get(0), (Double)list.get(1), (Double)list.get(2), (Double)list.get(3));
    }

    @Override
    ByteBuf doEncodeBinary(Line value) {
        return this.byteBufAllocator.buffer(24).writeDouble(value.getA()).writeDouble(value.getB()).writeDouble(value.getC());
    }

    @Override
    public PostgresTypeIdentifier getArrayDataType() {
        return PostgresqlObjectId.LINE_ARRAY;
    }
}

