/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.BuiltinCodecSupport;
import io.r2dbc.postgresql.codec.Interval;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.EnumSet;

final class IntervalCodec
extends BuiltinCodecSupport<Interval> {
    IntervalCodec(ByteBufAllocator byteBufAllocator) {
        super(Interval.class, byteBufAllocator, PostgresqlObjectId.INTERVAL, PostgresqlObjectId.INTERVAL_ARRAY, Interval::getValue);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return PostgresqlObjectId.INTERVAL == type && Format.FORMAT_TEXT == format;
    }

    @Override
    Interval doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends Interval> type) {
        return Interval.parse(ByteBufUtils.decode(buffer));
    }

    @Override
    public Iterable<Format> getFormats() {
        return EnumSet.of(Format.FORMAT_TEXT);
    }
}

