/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableMap;
import eu.timepit.refined.api.Refined;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxSetError$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.RemoveEmailsOnDestroy;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.method.MailboxHasChildException;
import org.apache.james.jmap.method.MailboxHasMailException;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$;
import org.apache.james.jmap.method.MailboxSetDeletePerformer$MailboxDeletionResults$;
import org.apache.james.jmap.method.MailboxSetMethod$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.util.AuditTrail;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r=u!\u0002-Z\u0011\u0003!g!\u00024Z\u0011\u00039\u0007\"\u00028\u0002\t\u0003y\u0007b\u00029\u0002\u0005\u0004%I!\u001d\u0005\u0007q\u0006\u0001\u000b\u0011\u0002:\u0007\u000fe\f\u0001\u0013aI\u0011u\u001a1\u0011q[\u0001A\u00033D!\"a\b\u0007\u0005+\u0007I\u0011AAn\u0011)\tyC\u0002B\tB\u0003%\u0011Q\u001c\u0005\u0007]\u001a!\t!!<\t\u0013\u0005Uc!!A\u0005\u0002\u0005M\b\"CA/\rE\u0005I\u0011AA|\u0011%\tYHBA\u0001\n\u0003\ni\bC\u0005\u0002\u0010\u001a\t\t\u0011\"\u0001\u0002\u0012\"I\u0011\u0011\u0014\u0004\u0002\u0002\u0013\u0005\u00111 \u0005\n\u0003O3\u0011\u0011!C!\u0003SC\u0011\"a.\u0007\u0003\u0003%\t!a@\t\u0013\u0005\rg!!A\u0005B\t\r\u0001\"CAe\r\u0005\u0005I\u0011IAf\u0011%\tiMBA\u0001\n\u0003\ny\rC\u0005\u0002R\u001a\t\t\u0011\"\u0011\u0003\b\u001dI!1B\u0001\u0002\u0002#\u0005!Q\u0002\u0004\n\u0003/\f\u0011\u0011!E\u0001\u0005\u001fAaA\u001c\f\u0005\u0002\t\u001d\u0002\"CAg-\u0005\u0005IQIAh\u0011%\u0011ICFA\u0001\n\u0003\u0013Y\u0003C\u0005\u00030Y\t\t\u0011\"!\u00032!I!Q\b\f\u0002\u0002\u0013%!q\b\u0004\u0005y\u0006\u0001U\u0010\u0003\u0006\u0002 q\u0011)\u001a!C\u0001\u0003CA!\"a\f\u001d\u0005#\u0005\u000b\u0011BA\u0012\u0011)\t\t\u0004\bBK\u0002\u0013\u0005\u00111\u0007\u0005\u000b\u0003wa\"\u0011#Q\u0001\n\u0005U\u0002B\u00028\u001d\t\u0003\ti\u0004C\u0004\u0002Fq!\t!a\u0012\t\u0013\u0005UC$!A\u0005\u0002\u0005]\u0003\"CA/9E\u0005I\u0011AA0\u0011%\t)\bHI\u0001\n\u0003\t9\bC\u0005\u0002|q\t\t\u0011\"\u0011\u0002~!I\u0011q\u0012\u000f\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u00033c\u0012\u0011!C\u0001\u00037C\u0011\"a*\u001d\u0003\u0003%\t%!+\t\u0013\u0005]F$!A\u0005\u0002\u0005e\u0006\"CAb9\u0005\u0005I\u0011IAc\u0011%\tI\rHA\u0001\n\u0003\nY\rC\u0005\u0002Nr\t\t\u0011\"\u0011\u0002P\"I\u0011\u0011\u001b\u000f\u0002\u0002\u0013\u0005\u00131[\u0004\n\u0005\u000f\n\u0011\u0011!E\u0001\u0005\u00132\u0001\u0002`\u0001\u0002\u0002#\u0005!1\n\u0005\u0007]B\"\tAa\u0015\t\u0013\u00055\u0007'!A\u0005F\u0005=\u0007\"\u0003B\u0015a\u0005\u0005I\u0011\u0011B+\u0011%\u0011y\u0003MA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003>A\n\t\u0011\"\u0003\u0003@\u00191!qM\u0001A\u0005SB!Ba\u001b7\u0005+\u0007I\u0011\u0001B7\u0011)\u0011)H\u000eB\tB\u0003%!q\u000e\u0005\u0007]Z\"\tAa\u001e\t\u000f\tud\u0007\"\u0001\u0003\u0000!9!1\u0011\u001c\u0005\u0002\t\u0015\u0005\"CA+m\u0005\u0005I\u0011\u0001BL\u0011%\tiFNI\u0001\n\u0003\u0011Y\nC\u0005\u0002|Y\n\t\u0011\"\u0011\u0002~!I\u0011q\u0012\u001c\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u000333\u0014\u0011!C\u0001\u0005?C\u0011\"a*7\u0003\u0003%\t%!+\t\u0013\u0005]f'!A\u0005\u0002\t\r\u0006\"CAbm\u0005\u0005I\u0011\tBT\u0011%\tIMNA\u0001\n\u0003\nY\rC\u0005\u0002NZ\n\t\u0011\"\u0011\u0002P\"I\u0011\u0011\u001b\u001c\u0002\u0002\u0013\u0005#1V\u0004\n\u0005_\u000b\u0011\u0011!E\u0001\u0005c3\u0011Ba\u001a\u0002\u0003\u0003E\tAa-\t\r9DE\u0011\u0001B\\\u0011%\ti\rSA\u0001\n\u000b\ny\rC\u0005\u0003*!\u000b\t\u0011\"!\u0003:\"I!q\u0006%\u0002\u0002\u0013\u0005%Q\u0018\u0005\n\u0005{A\u0015\u0011!C\u0005\u0005\u007f1QAZ-\u0001\u0005\u0007D!B!2O\u0005\u0003\u0005\u000b\u0011\u0002Bd\u0011)\u0011yM\u0014B\u0001B\u0003%!\u0011\u001b\u0005\u000b\u0005/t%\u0011!Q\u0001\n\te\u0007B\u00028O\t\u0003\u00119\u000fC\u0004\u0004\u00049#\ta!\u0002\t\u000f\r-c\n\"\u0003\u0004N!91Q\r(\u0005\n\r\u001d\u0004bBB=\u001d\u0012%11\u0010\u0005\b\u0007\u0007sE\u0011BBC\u0003ei\u0015-\u001b7c_b\u001cV\r\u001e#fY\u0016$X\rU3sM>\u0014X.\u001a:\u000b\u0005i[\u0016AB7fi\"|GM\u0003\u0002];\u0006!!.\\1q\u0015\tqv,A\u0003kC6,7O\u0003\u0002aC\u00061\u0011\r]1dQ\u0016T\u0011AY\u0001\u0004_J<7\u0001\u0001\t\u0003K\u0006i\u0011!\u0017\u0002\u001a\u001b\u0006LGNY8y'\u0016$H)\u001a7fi\u0016\u0004VM\u001d4pe6,'o\u0005\u0002\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00013\u0002\r1{uiR#S+\u0005\u0011\bCA:w\u001b\u0005!(BA;b\u0003\u0015\u0019HN\u001a\u001bk\u0013\t9HO\u0001\u0004M_\u001e<WM]\u0001\b\u0019>;u)\u0012*!\u0005Ui\u0015-\u001b7c_b$U\r\\3uS>t'+Z:vYR\u001c\"!\u00025*\u0007\u0015abA\u0001\fNC&d'm\u001c=EK2,G/[8o\r\u0006LG.\u001e:f'\u001da\u0002N`A\u0001\u0003\u000f\u0001\"a`\u0003\u000e\u0003\u0005\u00012![A\u0002\u0013\r\t)A\u001b\u0002\b!J|G-^2u!\u0011\tI!!\u0007\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C2\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0017bAA\fU\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1!a\u0006k\u0003%i\u0017-\u001b7c_bLE-\u0006\u0002\u0002$A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*m\u000bA!\\1jY&!\u0011QFA\u0014\u0005E)f\u000e]1sg\u0016$W*Y5mE>D\u0018\nZ\u0001\u000b[\u0006LGNY8y\u0013\u0012\u0004\u0013!C3yG\u0016\u0004H/[8o+\t\t)\u0004\u0005\u0003\u0002\n\u0005]\u0012\u0002BA\u001d\u0003;\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0015\u0015D8-\u001a9uS>t\u0007\u0005\u0006\u0004\u0002@\u0005\u0005\u00131\t\t\u0003\u007frAq!a\b\"\u0001\u0004\t\u0019\u0003C\u0004\u00022\u0005\u0002\r!!\u000e\u0002#\u0005\u001cX*Y5mE>D8+\u001a;FeJ|'/\u0006\u0002\u0002JA!\u00111JA)\u001b\t\tiEC\u0002\u0002Pm\u000bAaY8sK&!\u00111KA'\u0005!\u0019V\r^#se>\u0014\u0018\u0001B2paf$b!a\u0010\u0002Z\u0005m\u0003\"CA\u0010GA\u0005\t\u0019AA\u0012\u0011%\t\td\tI\u0001\u0002\u0004\t)$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005$\u0006BA\u0012\u0003GZ#!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_R\u0017AC1o]>$\u0018\r^5p]&!\u00111OA5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIH\u000b\u0003\u00026\u0005\r\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001\u00027b]\u001eT!!!#\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\u000b\u0019I\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00032![AK\u0013\r\t9J\u001b\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002j\u0003?K1!!)k\u0005\r\te.\u001f\u0005\n\u0003KC\u0013\u0011!a\u0001\u0003'\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAV!\u0019\ti+a-\u0002\u001e6\u0011\u0011q\u0016\u0006\u0004\u0003cS\u0017AC2pY2,7\r^5p]&!\u0011QWAX\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0016\u0011\u0019\t\u0004S\u0006u\u0016bAA`U\n9!i\\8mK\u0006t\u0007\"CASU\u0005\u0005\t\u0019AAO\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}\u0014q\u0019\u0005\n\u0003K[\u0013\u0011!a\u0001\u0003'\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003'\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007f\na!Z9vC2\u001cH\u0003BA^\u0003+D\u0011\"!*/\u0003\u0003\u0005\r!!(\u0003-5\u000b\u0017\u000e\u001c2pq\u0012+G.\u001a;j_:\u001cVoY2fgN\u001crA\u00025\u007f\u0003\u0003\t9!\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018!B7pI\u0016d'bAAt;\u00069Q.Y5mE>D\u0018\u0002BAv\u0003C\u0014\u0011\"T1jY\n|\u00070\u00133\u0015\t\u0005=\u0018\u0011\u001f\t\u0003\u007f\u001aAq!a\b\n\u0001\u0004\ti\u000e\u0006\u0003\u0002p\u0006U\b\"CA\u0010\u0015A\u0005\t\u0019AAo+\t\tIP\u000b\u0003\u0002^\u0006\rD\u0003BAO\u0003{D\u0011\"!*\u000f\u0003\u0003\u0005\r!a%\u0015\t\u0005m&\u0011\u0001\u0005\n\u0003K\u0003\u0012\u0011!a\u0001\u0003;#B!a \u0003\u0006!I\u0011QU\t\u0002\u0002\u0003\u0007\u00111\u0013\u000b\u0005\u0003w\u0013I\u0001C\u0005\u0002&R\t\t\u00111\u0001\u0002\u001e\u00061R*Y5mE>DH)\u001a7fi&|gnU;dG\u0016\u001c8\u000f\u0005\u0002\u0000-M)aC!\u0005\u0003\u001eAA!1\u0003B\r\u0003;\fy/\u0004\u0002\u0003\u0016)\u0019!q\u00036\u0002\u000fI,h\u000e^5nK&!!1\u0004B\u000b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")!!1EAD\u0003\tIw.\u0003\u0003\u0002\u001c\t\u0005BC\u0001B\u0007\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tyO!\f\t\u000f\u0005}\u0011\u00041\u0001\u0002^\u00069QO\\1qa2LH\u0003\u0002B\u001a\u0005s\u0001R!\u001bB\u001b\u0003;L1Aa\u000ek\u0005\u0019y\u0005\u000f^5p]\"I!1\b\u000e\u0002\u0002\u0003\u0007\u0011q^\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B!!\u0011\t\tIa\u0011\n\t\t\u0015\u00131\u0011\u0002\u0007\u001f\nTWm\u0019;\u0002-5\u000b\u0017\u000e\u001c2pq\u0012+G.\u001a;j_:4\u0015-\u001b7ve\u0016\u0004\"a \u0019\u0014\u000bA\u0012iE!\b\u0011\u0015\tM!qJA\u0012\u0003k\ty$\u0003\u0003\u0003R\tU!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!\u0011\n\u000b\u0007\u0003\u007f\u00119F!\u0017\t\u000f\u0005}1\u00071\u0001\u0002$!9\u0011\u0011G\u001aA\u0002\u0005UB\u0003\u0002B/\u0005K\u0002R!\u001bB\u001b\u0005?\u0002r!\u001bB1\u0003G\t)$C\u0002\u0003d)\u0014a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u001ei\u0005\u0005\t\u0019AA \u0005Yi\u0015-\u001b7c_b$U\r\\3uS>t'+Z:vYR\u001c8C\u0002\u001ci\u0003\u0003\t9!A\u0004sKN,H\u000e^:\u0016\u0005\t=\u0004#BA\u0005\u0005cr\u0018\u0002\u0002B:\u0003;\u00111aU3r\u0003!\u0011Xm];miN\u0004C\u0003\u0002B=\u0005w\u0002\"a \u001c\t\u000f\t-\u0014\b1\u0001\u0003p\u0005IA-Z:ue>LX\rZ\u000b\u0003\u0005\u0003\u0003b!!\u0003\u0003r\u0005u\u0017A\u0004:fiJLWM^3FeJ|'o]\u000b\u0003\u0005\u000f\u0003\u0002B!#\u0003\u0012\u0006\r\u0012\u0011\n\b\u0005\u0005\u0017\u0013i\tE\u0002\u0002\u000e)L1Aa$k\u0003\u0019\u0001&/\u001a3fM&!!1\u0013BK\u0005\ri\u0015\r\u001d\u0006\u0004\u0005\u001fSG\u0003\u0002B=\u00053C\u0011Ba\u001b=!\u0003\u0005\rAa\u001c\u0016\u0005\tu%\u0006\u0002B8\u0003G\"B!!(\u0003\"\"I\u0011Q\u0015!\u0002\u0002\u0003\u0007\u00111\u0013\u000b\u0005\u0003w\u0013)\u000bC\u0005\u0002&\n\u000b\t\u00111\u0001\u0002\u001eR!\u0011q\u0010BU\u0011%\t)kQA\u0001\u0002\u0004\t\u0019\n\u0006\u0003\u0002<\n5\u0006\"CAS\r\u0006\u0005\t\u0019AAO\u0003Yi\u0015-\u001b7c_b$U\r\\3uS>t'+Z:vYR\u001c\bCA@I'\u0015A%Q\u0017B\u000f!!\u0011\u0019B!\u0007\u0003p\teDC\u0001BY)\u0011\u0011IHa/\t\u000f\t-4\n1\u0001\u0003pQ!!q\u0018Ba!\u0015I'Q\u0007B8\u0011%\u0011Y\u0004TA\u0001\u0002\u0004\u0011Ih\u0005\u0002OQ\u0006qQ.Y5mE>DX*\u00198bO\u0016\u0014\b\u0003\u0002Be\u0005\u0017l!!!:\n\t\t5\u0017Q\u001d\u0002\u000f\u001b\u0006LGNY8y\u001b\u0006t\u0017mZ3s\u0003M\u0019XOY:de&\u0004H/[8o\u001b\u0006t\u0017mZ3s!\u0011\u0011IMa5\n\t\tU\u0017Q\u001d\u0002\u0014'V\u00147o\u0019:jaRLwN\\'b]\u0006<WM]\u0001\u0011[\u0006LGNY8y\u0013\u00124\u0015m\u0019;pef\u0004BAa7\u0003b:!\u0011q\u001cBo\u0013\u0011\u0011y.!9\u0002\u00135\u000b\u0017\u000e\u001c2pq&#\u0017\u0002\u0002Br\u0005K\u0014qAR1di>\u0014\u0018P\u0003\u0003\u0003`\u0006\u0005H\u0003\u0003Bu\u0005W\u0014iOa<\u0011\u0005\u0015t\u0005b\u0002Bc%\u0002\u0007!q\u0019\u0005\b\u0005\u001f\u0014\u0006\u0019\u0001Bi\u0011\u001d\u00119N\u0015a\u0001\u00053D3A\u0015Bz!\u0011\u0011)Pa@\u000e\u0005\t](\u0002\u0002B}\u0005w\fa!\u001b8kK\u000e$(B\u0001B\u007f\u0003\u001dQ\u0017m[1si\u0006LAa!\u0001\u0003x\n1\u0011J\u001c6fGR\fq\u0002Z3mKR,W*Y5mE>DXm\u001d\u000b\t\u0007\u000f\u0019\u0019d!\u0010\u0004HA11\u0011BB\f\u00077i!aa\u0003\u000b\t\r51qB\u0001\naV\u0014G.[:iKJT1a[B\t\u0015\u0011\tyea\u0005\u000b\u0005\rU\u0011a\u0002:fC\u000e$xN]\u0005\u0005\u00073\u0019YAA\u0003T\u001b>tw\u000eE\u0002\u0004\u001eYr1aa\b\u0001\u001d\u0011\u0019\tc!\r\u000f\t\r\r2q\u0006\b\u0005\u0007K\u0019iC\u0004\u0003\u0004(\r-b\u0002BA\u0007\u0007SI\u0011AY\u0005\u0003A\u0006L!AX0\n\u0005qk\u0016B\u0001.\\\u0011\u001d\u0019)d\u0015a\u0001\u0007o\ta\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0003J\u000ee\u0012\u0002BB\u001e\u0003K\u0014a\"T1jY\n|\u0007pU3tg&|g\u000eC\u0004\u0004@M\u0003\ra!\u0011\u0002#5\f\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0002&\r\r\u0013\u0002BB#\u0003O\u0011\u0011#T1jY\n|\u0007pU3u%\u0016\fX/Z:u\u0011\u001d\u0019Ie\u0015a\u0001\u0003w\u000bAc];qa>\u0014Ho\u00155be\u0016$W*Y5mE>D\u0018A\u00023fY\u0016$X\r\u0006\u0006\u0004P\rM3QKB-\u0007G\u0002ba!\u0003\u0004\u0018\rE\u0003cAB\u000f\u000b!91Q\u0007+A\u0002\r]\u0002bBB,)\u0002\u0007\u00111E\u0001\u0003S\u0012Dqaa\u0017U\u0001\u0004\u0019i&A\u0005p]\u0012+7\u000f\u001e:psB!\u0011QEB0\u0013\u0011\u0019\t'a\n\u0003+I+Wn\u001c<f\u000b6\f\u0017\u000e\\:P]\u0012+7\u000f\u001e:ps\"91\u0011\n+A\u0002\u0005m\u0016\u0001\u00033p\t\u0016dW\r^3\u0015\u0015\r%4\u0011OB:\u0007k\u001a9\b\u0005\u0004\u0004\n\r]11\u000e\t\u0004S\u000e5\u0014bAB8U\n!QK\\5u\u0011\u001d\u0019)$\u0016a\u0001\u0007oAqaa\u0016V\u0001\u0004\ti\u000eC\u0004\u0004\\U\u0003\ra!\u0018\t\u000f\r%S\u000b1\u0001\u0002<\u0006Q\u0011-\u001e3jiR\u0013\u0018-\u001b7\u0015\r\r-4QPB@\u0011\u001d\u0019)D\u0016a\u0001\u0007oAqa!!W\u0001\u0004\u0019Y\"\u0001\fnC&d'm\u001c=EK2,G/[8o%\u0016\u001cX\u000f\u001c;t\u0003AI7/Q*zgR,W.T1jY\n|\u0007\u0010\u0006\u0003\u0002<\u000e\u001d\u0005bBAt/\u0002\u00071\u0011\u0012\t\u0005\u0005\u0013\u001cY)\u0003\u0003\u0004\u000e\u0006\u0015(AD'fgN\fw-Z'b]\u0006<WM\u001d")
public class MailboxSetDeletePerformer {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxDeletionResults> deleteMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, boolean supportSharedMailbox) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)((IterableOnceOps)mailboxSetRequest.destroy().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$)).toSet());
        Function1 & Serializable x$1 = (Function1 & Serializable)id -> this.delete(mailboxSession, (UnparsedMailboxId)id, ((RemoveEmailsOnDestroy)mailboxSetRequest.onDestroyRemoveEmails().getOrElse((Function0 & Serializable)() -> new RemoveEmailsOnDestroy(MailboxSetDeletePerformer.$anonfun$deleteMailboxes$3()))).value(), supportSharedMailbox).onErrorRecover((PartialFunction)new Serializable(null, (UnparsedMailboxId)id){
            private static final long serialVersionUID = 0L;
            private final UnparsedMailboxId id$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                return (B1)new MailboxDeletionFailure(this.id$1, e);
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                return true;
            }
            {
                this.id$1 = id$1;
            }
        });
        int x$22 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetDeletePerformer$MailboxDeletionResults$.MODULE$).doOnSuccess((Function1 & Serializable)x$2 -> {
            this.auditTrail(mailboxSession, x$2);
            return BoxedUnit.UNIT;
        });
    }

    private SMono<MailboxDeletionResult> delete(MailboxSession mailboxSession, UnparsedMailboxId id2, boolean onDestroy, boolean supportSharedMailbox) {
        return (SMono)MailboxGet$.MODULE$.parse(this.mailboxIdFactory, id2).fold((Function1 & Serializable)e -> SMono$.MODULE$.error(e), (Function1 & Serializable)id -> this.doDelete(mailboxSession, (MailboxId)id, onDestroy, supportSharedMailbox).then(SMono$.MODULE$.just((Object)new MailboxDeletionSuccess((MailboxId)id))));
    }

    private SMono<BoxedUnit> doDelete(MailboxSession mailboxSession, MailboxId id, boolean onDestroy, boolean supportSharedMailbox) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(id, mailboxSession)).filterWhen(MailboxSetMethod$.MODULE$.assertCapabilityIfSharedMailbox(mailboxSession, id, supportSharedMailbox)).flatMap((Function1 & Serializable)mailbox -> SMono$.MODULE$.apply($this.mailboxManager.hasChildrenReactive(mailbox.getMailboxPath(), mailboxSession)).flatMap((Function1 & Serializable)hasChildren -> {
            if (this.isASystemMailbox((MessageManager)mailbox)) {
                throw new SystemMailboxChangeException(id);
            }
            if (Predef$.MODULE$.Boolean2boolean(hasChildren)) {
                throw new MailboxHasChildException(id);
            }
            if (onDestroy) {
                return SMono$.MODULE$.apply((Publisher)$this.mailboxManager.deleteMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)deletedMailbox -> SMono$.MODULE$.apply($this.subscriptionManager.unsubscribeReactive(deletedMailbox.generateAssociatedPath(), mailboxSession))).then();
            }
            return SMono$.MODULE$.apply(mailbox.getMessagesReactive(MessageRange.all(), FetchGroup.MINIMAL, mailboxSession)).hasElement().handle((Function2 & Serializable)(hasElement, sink) -> {
                MailboxSetDeletePerformer.$anonfun$doDelete$4(id, BoxesRunTime.unboxToBoolean((Object)hasElement), sink);
                return BoxedUnit.UNIT;
            }).then(SMono$.MODULE$.apply((Publisher)$this.mailboxManager.deleteMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)deletedMailbox -> SMono$.MODULE$.apply($this.subscriptionManager.unsubscribeReactive(deletedMailbox.generateAssociatedPath(), mailboxSession))).then());
        }));
    }

    private void auditTrail(MailboxSession mailboxSession, MailboxDeletionResults mailboxDeletionResults) {
        if (mailboxDeletionResults.destroyed().nonEmpty()) {
            ReactorUtils.logAsMono(() -> AuditTrail.entry().username(() -> mailboxSession.getUser().asString()).protocol("JMAP").action("Mailbox/set destroy").parameters(() -> ImmutableMap.of((Object)"loggedInUser", (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).map((Function1 & Serializable)x$3 -> x$3.asString()).getOrElse((Function0 & Serializable)() -> ""), (Object)"mailboxIds", (Object)StringUtils.join((Object[])new Seq[]{mailboxDeletionResults.destroyed()}))).log("JMAP mailbox delete succeeded."));
            return;
        }
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$deleteMailboxes$3() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$doDelete$4(MailboxId id$2, boolean hasElement, SynchronousSink sink) {
        if (hasElement) {
            sink.error((Throwable)new MailboxHasMailException(id$2));
            return;
        }
    }

    @Inject
    public MailboxSetDeletePerformer(MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxDeletionFailure
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a non existing mailbox: {}", (Object)mailboxNotFoundException.getMessage());
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxHasMailException) {
                MailboxHasMailException mailboxHasMailException = (MailboxHasMailException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a mailbox with mails");
                return MailboxSetError$.MODULE$.mailboxHasEmail(mailboxHasMailException.mailboxId().serialize() + " is not empty");
            }
            if (throwable instanceof MailboxHasChildException) {
                MailboxHasChildException mailboxHasChildException = (MailboxHasChildException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a mailbox with children");
                return MailboxSetError$.MODULE$.mailboxHasChild(mailboxHasChildException.mailboxId().serialize() + " has child mailboxes");
            }
            if (throwable instanceof SystemMailboxChangeException) {
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a system folder");
                return SetError$.MODULE$.invalidArguments("System mailboxes cannot be destroyed", SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Illegal argument in Mailbox/set delete", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(new Refined((Object)this.mailboxId().id()) + " is not a mailboxId: " + illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof InsufficientRightsException) {
                InsufficientRightsException insufficientRightsException = (InsufficientRightsException)throwable;
                MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().info("Attempt to delete a mailbox without sufficient rights");
                return SetError$.MODULE$.invalidArguments(insufficientRightsException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            MailboxSetDeletePerformer$.MODULE$.org$apache$james$jmap$method$MailboxSetDeletePerformer$$LOGGER().error("Failed to delete mailbox", throwable);
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxDeletionFailure copy(UnparsedMailboxId mailboxId, Throwable exception) {
            return new MailboxDeletionFailure(mailboxId, exception);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxDeletionFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxDeletionFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxDeletionFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!mailboxDeletionFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionFailure(UnparsedMailboxId mailboxId, Throwable exception) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxDeletionResult {
    }

    public static class MailboxDeletionResults
    implements Product,
    Serializable {
        private final Seq<MailboxDeletionResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxDeletionResult> results() {
            return this.results;
        }

        public Seq<MailboxId> destroyed() {
            return (Seq)((IterableOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionSuccess) {
                    MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)mailboxDeletionResult;
                    return new Some((Object)mailboxDeletionSuccess);
                }
                return None$.MODULE$;
            })).map((Function1 & Serializable)x$1 -> x$1.mailboxId());
        }

        public Map<UnparsedMailboxId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxDeletionResult mailboxDeletionResult = result;
                if (mailboxDeletionResult instanceof MailboxDeletionFailure) {
                    MailboxDeletionFailure mailboxDeletionFailure = (MailboxDeletionFailure)mailboxDeletionResult;
                    return new Some((Object)new Tuple2((Object)mailboxDeletionFailure.mailboxId(), (Object)mailboxDeletionFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxDeletionResults copy(Seq<MailboxDeletionResult> results) {
            return new MailboxDeletionResults(results);
        }

        public Seq<MailboxDeletionResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxDeletionResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionResults mailboxDeletionResults = (MailboxDeletionResults)x$1;
            Seq<MailboxDeletionResult> seq = this.results();
            Seq<MailboxDeletionResult> seq2 = mailboxDeletionResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxDeletionResults.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionResults(Seq<MailboxDeletionResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxDeletionSuccess
    implements MailboxDeletionResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxDeletionSuccess copy(MailboxId mailboxId) {
            return new MailboxDeletionSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxDeletionSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxDeletionSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxDeletionSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxDeletionSuccess mailboxDeletionSuccess = (MailboxDeletionSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxDeletionSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxDeletionSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxDeletionSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

