/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet;

import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.OriginalMessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ExtractMDNOriginalJMAPMessageId
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractMDNOriginalJMAPMessageId.class);
    private static final String X_JAMES_MDN_JMAP_MESSAGE_ID = "X-JAMES-MDN-JMAP-MESSAGE-ID";
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    public ExtractMDNOriginalJMAPMessageId(MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getRecipients().size() != 1) {
            LOGGER.warn("MDN should only be sent to a single recipient");
            return;
        }
        MailAddress recipient = (MailAddress)Iterables.getOnlyElement((Iterable)mail.getRecipients());
        MimeMessage mimeMessage = mail.getMessage();
        try {
            Message message = new DefaultMessageBuilder().parseMessage((InputStream)new MimeMessageInputStream(mimeMessage));
            Optional.of(MDN.parse((Message)message)).map(MDN::getReport).flatMap(MDNReport::getOriginalMessageIdField).map(OriginalMessageId::getOriginalMessageId).flatMap(messageId -> this.findMessageIdForRFC822MessageId((String)messageId, recipient)).ifPresent(messageId -> this.setJmapMessageIdAsHeader(mimeMessage, (MessageId)messageId));
            message.dispose();
        }
        catch (Exception e) {
            throw new MessagingException("MDN can't be parse", e);
        }
    }

    private void setJmapMessageIdAsHeader(MimeMessage mimeMessage, MessageId messageId) {
        LOGGER.debug("Adding header {}:{}", (Object)X_JAMES_MDN_JMAP_MESSAGE_ID, (Object)messageId.serialize());
        try {
            mimeMessage.addHeader(X_JAMES_MDN_JMAP_MESSAGE_ID, messageId.serialize());
        }
        catch (MessagingException e) {
            LOGGER.error("unable to add X-JAMES-MDN-JMAP-MESSAGE-ID header to message", (Throwable)e);
        }
    }

    private Optional<MessageId> findMessageIdForRFC822MessageId(String messageId, MailAddress recipient) {
        LOGGER.debug("Searching message {} for recipient {}", (Object)messageId, (Object)recipient.asPrettyString());
        try {
            MailboxSession session = this.mailboxManager.createSystemSession(this.usersRepository.getUsername(recipient));
            int limit = 1;
            MultimailboxesSearchQuery searchByRFC822MessageId = MultimailboxesSearchQuery.from((SearchQuery)SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.mimeMessageID((String)messageId)})).build();
            return Flux.from((Publisher)this.mailboxManager.search(searchByRFC822MessageId, session, (long)limit)).toStream().findFirst();
        }
        catch (UsersRepositoryException e) {
            LOGGER.error("unable to find message with Message-Id: " + messageId, (Throwable)e);
            return Optional.empty();
        }
    }

    public String getMailetInfo() {
        return "ExtractMDNOriginalJMAPMessageId";
    }
}

