/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.vault.routes;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.vault.dto.query.QueryDTO;
import org.apache.james.vault.dto.query.QueryElement;
import org.apache.james.vault.dto.query.QueryTranslator;
import org.apache.james.vault.search.Query;
import org.apache.james.webadmin.vault.routes.DeletedMessagesVaultExportTask;
import org.apache.james.webadmin.vault.routes.ExportService;

public class DeletedMessagesVaultExportTaskDTO
implements TaskDTO {
    private final String type;
    private final String userExportFrom;
    private final QueryDTO exportQuery;
    private final String exportTo;

    public static TaskDTOModule<DeletedMessagesVaultExportTask, DeletedMessagesVaultExportTaskDTO> module(Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(DeletedMessagesVaultExportTask.class).convertToDTO(DeletedMessagesVaultExportTaskDTO.class).toDomainObjectConverter(dto -> {
            try {
                return factory.create((DeletedMessagesVaultExportTaskDTO)dto);
            }
            catch (AddressException e) {
                throw new RuntimeException(e);
            }
        }).toDTOConverter(factory::createDTO).typeName(DeletedMessagesVaultExportTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public DeletedMessagesVaultExportTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="userExportFrom") String userExportFrom, @JsonProperty(value="exportQuery") QueryDTO exportQuery, @JsonProperty(value="exportTo") String exportTo) {
        this.type = type;
        this.userExportFrom = userExportFrom;
        this.exportQuery = exportQuery;
        this.exportTo = exportTo;
    }

    public String getUserExportFrom() {
        return this.userExportFrom;
    }

    public QueryDTO getExportQuery() {
        return this.exportQuery;
    }

    public String getExportTo() {
        return this.exportTo;
    }

    public String getType() {
        return this.type;
    }

    public static class Factory {
        private final ExportService exportService;
        private final QueryTranslator queryTranslator;

        @Inject
        public Factory(ExportService exportService, QueryTranslator queryTranslator) {
            this.exportService = exportService;
            this.queryTranslator = queryTranslator;
        }

        public DeletedMessagesVaultExportTask create(DeletedMessagesVaultExportTaskDTO dto) throws AddressException {
            Username userExportFrom = Username.of((String)dto.userExportFrom);
            Query exportQuery = this.queryTranslator.translate((QueryElement)dto.exportQuery);
            MailAddress exportTo = new MailAddress(dto.exportTo);
            return new DeletedMessagesVaultExportTask(this.exportService, userExportFrom, exportQuery, exportTo);
        }

        DeletedMessagesVaultExportTaskDTO createDTO(DeletedMessagesVaultExportTask task, String type) {
            return new DeletedMessagesVaultExportTaskDTO(type, task.getUserExportFrom().asString(), this.queryTranslator.toDTO(task.getExportQuery()), task.getExportTo().asString());
        }
    }
}

