/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.NotInfluenceReceiveTimeout;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.ActorContextImpl;
import org.apache.pekko.actor.typed.internal.BehaviorImpl;
import org.apache.pekko.actor.typed.internal.TimerSchedulerCrossDslSupport;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$;
import org.apache.pekko.actor.typed.internal.TimerSchedulerImpl$SingleMode$;
import org.apache.pekko.actor.typed.javadsl.TimerScheduler;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.util.LineNumbers$;
import org.apache.pekko.util.OptionVal$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011\u001duACA\u0001\u0003\u0007A\t!a\u0004\u0002\u001c\u0019Q\u0011qDA\u0002\u0011\u0003\ty!!\t\t\u000f\u0005=\u0012\u0001\"\u0001\u00024\u00191\u0011QG\u0001C\u0003oA!\"!\u0017\u0004\u0005+\u0007I\u0011AA.\u0011)\t\u0019g\u0001B\tB\u0003%\u0011Q\f\u0005\u000b\u0003K\u001a!Q3A\u0005\u0002\u0005\u001d\u0004BCA=\u0007\tE\t\u0015!\u0003\u0002j!Q\u00111P\u0002\u0003\u0016\u0004%\t!! \t\u0015\u0005\u00155A!E!\u0002\u0013\ty\b\u0003\u0006\u0002\b\u000e\u0011)\u001a!C\u0001\u0003\u0013C!\"!%\u0004\u0005#\u0005\u000b\u0011BAF\u0011)\t\u0019j\u0001BK\u0002\u0013\u0005\u0011Q\u0013\u0005\u000b\u0003?\u001b!\u0011#Q\u0001\n\u0005]\u0005bBA\u0018\u0007\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003c\u001b\u0011\u0011!C\u0001\u0003gC\u0011\"a2\u0004#\u0003%\t!!3\t\u0013\u0005\r8!%A\u0005\u0002\u0005\u0015\b\"CAw\u0007E\u0005I\u0011AAx\u0011%\t9pAI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0002\r\t\n\u0011\"\u0001\u0003\u0004!I!1B\u0002\u0002\u0002\u0013\u0005#Q\u0002\u0005\n\u0005?\u0019\u0011\u0011!C\u0001\u0003\u0013C\u0011B!\t\u0004\u0003\u0003%\tAa\t\t\u0013\t%2!!A\u0005B\t-\u0002\"\u0003B\u001d\u0007\u0005\u0005I\u0011\u0001B\u001e\u0011%\u0011ydAA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003F\r\t\t\u0011\"\u0011\u0003H!I!\u0011J\u0002\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005\u001b\u001a\u0011\u0011!C!\u0005\u001f:\u0011Ba\u0015\u0002\u0003\u0003E\tA!\u0016\u0007\u0013\u0005U\u0012!!A\t\u0002\t]\u0003bBA\u0018?\u0011\u0005!1\r\u0005\n\u0005\u0013z\u0012\u0011!C#\u0005\u0017B\u0011B!\u001a \u0003\u0003%\tIa\u001a\t\u0013\tmt$!A\u0005\u0002\nu\u0004\"\u0003BL?\u0005\u0005I\u0011\u0002BM\r\u0019\u0011\t+\u0001\t\u0003$\"Q\u0011\u0011L\u0013\u0003\u0006\u0004%\t!a\u0017\t\u0015\u0005\rTE!A!\u0002\u0013\ti\u0006\u0003\u0006\u0002\b\u0016\u0012)\u0019!C\u0001\u0003\u0013C!\"!%&\u0005\u0003\u0005\u000b\u0011BAF\u0011)\u0011)+\nBC\u0002\u0013\u0005!q\u0015\u0005\u000b\u0005S+#\u0011!Q\u0001\n\u0005\r\u0002bBA\u0018K\u0011\u0005!1\u0016\u0005\b\u0005\u0013*C\u0011\tB&\u0011\u001d\u0011i,\u0001C\u0001\u0005\u007fCqAa8\u0002\t\u0003\u0011\tOB\u0005\u0004\u0004\u0005\u0001\n1%\u000b\u0004\u0006!9\u00111\u0010\u0019\u0007\u0002\u0005udABB\"\u0003\u0011\u001b)\u0005\u0003\u0006\u0004\u0010I\u0012)\u001a!C\u0001\u0007#A!ba\t3\u0005#\u0005\u000b\u0011BB\n\u0011\u001d\tyC\rC\u0001\u0007\u000fBq!a\u001f3\t\u0003\ni\bC\u0005\u00022J\n\t\u0011\"\u0001\u0004N!I\u0011q\u0019\u001a\u0012\u0002\u0013\u00051q\u0006\u0005\n\u0005\u0017\u0011\u0014\u0011!C!\u0005\u001bA\u0011Ba\b3\u0003\u0003%\t!!#\t\u0013\t\u0005\"'!A\u0005\u0002\rE\u0003\"\u0003B\u0015e\u0005\u0005I\u0011\tB\u0016\u0011%\u0011IDMA\u0001\n\u0003\u0019)\u0006C\u0005\u0003@I\n\t\u0011\"\u0011\u0004Z!I!Q\t\u001a\u0002\u0002\u0013\u0005#q\t\u0005\n\u0005\u0013\u0012\u0014\u0011!C!\u0005\u0017B\u0011B!\u00143\u0003\u0003%\te!\u0018\b\u0013\rE\u0014!!A\t\n\rMd!CB\"\u0003\u0005\u0005\t\u0012BB;\u0011\u001d\tyc\u0011C\u0001\u0007\u0007C\u0011B!\u0013D\u0003\u0003%)Ea\u0013\t\u0013\t\u00154)!A\u0005\u0002\u000e\u0015\u0005\"\u0003B>\u0007\u0006\u0005I\u0011QBE\u0011%\u00119jQA\u0001\n\u0013\u0011IJ\u0002\u0004\u0004\n\u0005!51\u0002\u0005\u000b\u0007\u001fI%Q3A\u0005\u0002\rE\u0001BCB\u0012\u0013\nE\t\u0015!\u0003\u0004\u0014!9\u0011qF%\u0005\u0002\r\u0015\u0002bBA>\u0013\u0012\u0005\u0013Q\u0010\u0005\n\u0003cK\u0015\u0011!C\u0001\u0007WA\u0011\"a2J#\u0003%\taa\f\t\u0013\t-\u0011*!A\u0005B\t5\u0001\"\u0003B\u0010\u0013\u0006\u0005I\u0011AAE\u0011%\u0011\t#SA\u0001\n\u0003\u0019\u0019\u0004C\u0005\u0003*%\u000b\t\u0011\"\u0011\u0003,!I!\u0011H%\u0002\u0002\u0013\u00051q\u0007\u0005\n\u0005\u007fI\u0015\u0011!C!\u0007wA\u0011B!\u0012J\u0003\u0003%\tEa\u0012\t\u0013\t%\u0013*!A\u0005B\t-\u0003\"\u0003B'\u0013\u0006\u0005I\u0011IB \u000f%\u0019y)AA\u0001\u0012\u0013\u0019\tJB\u0005\u0004\n\u0005\t\t\u0011#\u0003\u0004\u0014\"9\u0011q\u0006.\u0005\u0002\r]\u0005\"\u0003B%5\u0006\u0005IQ\tB&\u0011%\u0011)GWA\u0001\n\u0003\u001bI\nC\u0005\u0003|i\u000b\t\u0011\"!\u0004\u001e\"I!q\u0013.\u0002\u0002\u0013%!\u0011T\u0004\b\u0007C\u000b\u0001\u0012RB4\r\u001d\u0019\t'\u0001EE\u0007GBq!a\fb\t\u0003\u0019)\u0007C\u0004\u0002|\u0005$\t%! \t\u0013\t-\u0011-!A\u0005B\t5\u0001\"\u0003B\u0010C\u0006\u0005I\u0011AAE\u0011%\u0011\t#YA\u0001\n\u0003\u0019I\u0007C\u0005\u0003*\u0005\f\t\u0011\"\u0011\u0003,!I!\u0011H1\u0002\u0002\u0013\u00051Q\u000e\u0005\n\u0005\u000b\n\u0017\u0011!C!\u0005\u000fB\u0011B!\u0013b\u0003\u0003%\tEa\u0013\t\u0013\t]\u0015-!A\u0005\n\tee!CA\u0010\u0003\u0007\u0001\u0011qBBY\u0011)\u0011y\u000f\u001cB\u0001B\u0003%1\u0011\u0019\u0005\b\u0003_aG\u0011ABb\u0011%\u0019I\r\u001ca\u0001\n\u0013\u0019Y\rC\u0005\u0004b2\u0004\r\u0011\"\u0003\u0004d\"A1Q\u001e7!B\u0013\u0019i\rC\u0005\u0004p2\u0014\r\u0011\"\u0003\u0004r\"A1Q\u001f7!\u0002\u0013\u0019\u0019\u0010C\u0004\u0004x2$\te!?\t\u000f\r]H\u000e\"\u0011\u0005\u0004!9AQ\u00027\u0005B\u0011=\u0001b\u0002C\u0007Y\u0012\u0005C\u0011\u0004\u0005\b\tGaG\u0011\tC\u0013\u0011\u001d!i\u0003\u001cC!\t_Aq\u0001b\u000em\t\u0013!I\u0004C\u0004\u0005H1$\t\u0005\"\u0013\t\u000f\u00115C\u000e\"\u0011\u0005P!9A1\u000b7\u0005\n\u0011U\u0003b\u0002C.Y\u0012\u0005CQ\f\u0005\b\t?bG\u0011\u0001C1\u0003I!\u0016.\\3s'\u000eDW\rZ;mKJLU\u000e\u001d7\u000b\t\u0005\u0015\u0011qA\u0001\tS:$XM\u001d8bY*!\u0011\u0011BA\u0006\u0003\u0015!\u0018\u0010]3e\u0015\u0011\ti!a\u0004\u0002\u000b\u0005\u001cGo\u001c:\u000b\t\u0005E\u00111C\u0001\u0006a\u0016\\7n\u001c\u0006\u0005\u0003+\t9\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u00033\t1a\u001c:h!\r\ti\"A\u0007\u0003\u0003\u0007\u0011!\u0003V5nKJ\u001c6\r[3ek2,'/S7qYN\u0019\u0011!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ!!!\u000b\u0002\u000bM\u001c\u0017\r\\1\n\t\u00055\u0012q\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\"!a\u0007\u0003\u000bQKW.\u001a:\u0016\t\u0005e\u0012QN\n\b\u0007\u0005\r\u00121HA!!\u0011\t)#!\u0010\n\t\u0005}\u0012q\u0005\u0002\b!J|G-^2u!\u0011\t\u0019%a\u0015\u000f\t\u0005\u0015\u0013q\n\b\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)!\u00111JA\u0019\u0003\u0019a$o\\8u}%\u0011\u0011\u0011F\u0005\u0005\u0003#\n9#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0013q\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0003#\n9#A\u0002lKf,\"!!\u0018\u0011\t\u0005\u0015\u0012qL\u0005\u0005\u0003C\n9CA\u0002B]f\fAa[3zA\u0005\u0019Qn]4\u0016\u0005\u0005%\u0004\u0003BA6\u0003[b\u0001\u0001B\u0004\u0002p\r\u0011\r!!\u001d\u0003\u0003Q\u000bB!a\u001d\u0002^A!\u0011QEA;\u0013\u0011\t9(a\n\u0003\u000f9{G\u000f[5oO\u0006!Qn]4!\u0003\u0019\u0011X\r]3biV\u0011\u0011q\u0010\t\u0005\u0003K\t\t)\u0003\u0003\u0002\u0004\u0006\u001d\"a\u0002\"p_2,\u0017M\\\u0001\be\u0016\u0004X-\u0019;!\u0003)9WM\\3sCRLwN\\\u000b\u0003\u0003\u0017\u0003B!!\n\u0002\u000e&!\u0011qRA\u0014\u0005\rIe\u000e^\u0001\fO\u0016tWM]1uS>t\u0007%\u0001\u0003uCN\\WCAAL!\u0011\tI*a'\u000e\u0005\u0005-\u0011\u0002BAO\u0003\u0017\u00111bQ1oG\u0016dG.\u00192mK\u0006)A/Y:lAQa\u00111UAT\u0003S\u000bY+!,\u00020B)\u0011QU\u0002\u0002j5\t\u0011\u0001C\u0004\u0002Z9\u0001\r!!\u0018\t\u000f\u0005\u0015d\u00021\u0001\u0002j!9\u00111\u0010\bA\u0002\u0005}\u0004bBAD\u001d\u0001\u0007\u00111\u0012\u0005\b\u0003's\u0001\u0019AAL\u0003\u0011\u0019w\u000e]=\u0016\t\u0005U\u00161\u0018\u000b\r\u0003o\u000bi,a0\u0002B\u0006\r\u0017Q\u0019\t\u0006\u0003K\u001b\u0011\u0011\u0018\t\u0005\u0003W\nY\fB\u0004\u0002p=\u0011\r!!\u001d\t\u0013\u0005es\u0002%AA\u0002\u0005u\u0003\"CA3\u001fA\u0005\t\u0019AA]\u0011%\tYh\u0004I\u0001\u0002\u0004\ty\bC\u0005\u0002\b>\u0001\n\u00111\u0001\u0002\f\"I\u00111S\b\u0011\u0002\u0003\u0007\u0011qS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0011\tY-!9\u0016\u0005\u00055'\u0006BA/\u0003\u001f\\#!!5\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u00037\f9#\u0001\u0006b]:|G/\u0019;j_:LA!a8\u0002V\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005=\u0004C1\u0001\u0002r\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T\u0003BAt\u0003W,\"!!;+\t\u0005%\u0014q\u001a\u0003\b\u0003_\n\"\u0019AA9\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*B!!=\u0002vV\u0011\u00111\u001f\u0016\u0005\u0003\u007f\ny\rB\u0004\u0002pI\u0011\r!!\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU!\u00111`A\u0000+\t\tiP\u000b\u0003\u0002\f\u0006=GaBA8'\t\u0007\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\u0011\u0011)A!\u0003\u0016\u0005\t\u001d!\u0006BAL\u0003\u001f$q!a\u001c\u0015\u0005\u0004\t\t(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u001f\u0001BA!\u0005\u0003\u001c5\u0011!1\u0003\u0006\u0005\u0005+\u00119\"\u0001\u0003mC:<'B\u0001B\r\u0003\u0011Q\u0017M^1\n\t\tu!1\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\fB\u0013\u0011%\u00119cFA\u0001\u0002\u0004\tY)A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005[\u0001bAa\f\u00036\u0005uSB\u0001B\u0019\u0015\u0011\u0011\u0019$a\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00038\tE\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a \u0003>!I!qE\r\u0002\u0002\u0003\u0007\u0011QL\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0010\t\r\u0003\"\u0003B\u00145\u0005\u0005\t\u0019AAF\u0003!A\u0017m\u001d5D_\u0012,GCAAF\u0003!!xn\u0015;sS:<GC\u0001B\b\u0003\u0019)\u0017/^1mgR!\u0011q\u0010B)\u0011%\u00119#HA\u0001\u0002\u0004\ti&A\u0003US6,'\u000fE\u0002\u0002&~\u0019RaHA\u0012\u00053\u0002BAa\u0017\u0003b5\u0011!Q\f\u0006\u0005\u0005?\u00129\"\u0001\u0002j_&!\u0011Q\u000bB/)\t\u0011)&A\u0003baBd\u00170\u0006\u0003\u0003j\t=D\u0003\u0004B6\u0005c\u0012\u0019H!\u001e\u0003x\te\u0004#BAS\u0007\t5\u0004\u0003BA6\u0005_\"q!a\u001c#\u0005\u0004\t\t\bC\u0004\u0002Z\t\u0002\r!!\u0018\t\u000f\u0005\u0015$\u00051\u0001\u0003n!9\u00111\u0010\u0012A\u0002\u0005}\u0004bBADE\u0001\u0007\u00111\u0012\u0005\b\u0003'\u0013\u0003\u0019AAL\u0003\u001d)h.\u00199qYf,BAa \u0003\u0010R!!\u0011\u0011BI!\u0019\t)Ca!\u0003\b&!!QQA\u0014\u0005\u0019y\u0005\u000f^5p]Bq\u0011Q\u0005BE\u0003;\u0012i)a \u0002\f\u0006]\u0015\u0002\u0002BF\u0003O\u0011a\u0001V;qY\u0016,\u0004\u0003BA6\u0005\u001f#q!a\u001c$\u0005\u0004\t\t\bC\u0005\u0003\u0014\u000e\n\t\u00111\u0001\u0003\u0016\u0006\u0019\u0001\u0010\n\u0019\u0011\u000b\u0005\u00156A!$\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tm\u0005\u0003\u0002B\t\u0005;KAAa(\u0003\u0014\t1qJ\u00196fGR\u0014\u0001\u0002V5nKJl5oZ\n\u0004K\u0005\r\u0012!B8x]\u0016\u0014XCAA\u0012\u0003\u0019ywO\\3sAQA!Q\u0016BX\u0005c\u0013\u0019\fE\u0002\u0002&\u0016Bq!!\u0017-\u0001\u0004\ti\u0006C\u0004\u0002\b2\u0002\r!a#\t\u000f\t\u0015F\u00061\u0001\u0002$%\u001aQEa.\u0007\r\teV\u0005\u0001B^\u00055aDn\\2bY\u0002\u001a\u0007.\u001b7e}M!!q\u0017BW\u0003)9\u0018\u000e\u001e5US6,'o]\u000b\u0005\u0005\u0003\u0014i\r\u0006\u0003\u0003D\n=\u0007C\u0002Bc\u0005\u000f\u0014Y-\u0004\u0002\u0002\b%!!\u0011ZA\u0004\u0005!\u0011U\r[1wS>\u0014\b\u0003BA6\u0005\u001b$q!a\u001c/\u0005\u0004\t\t\bC\u0004\u0003R:\u0002\rAa5\u0002\u000f\u0019\f7\r^8ssBA\u0011Q\u0005Bk\u00053\u0014\u0019-\u0003\u0003\u0003X\u0006\u001d\"!\u0003$v]\u000e$\u0018n\u001c82!\u0019\tiBa7\u0003L&!!Q\\A\u0002\u0005u!\u0016.\\3s'\u000eDW\rZ;mKJ\u001c%o\\:t\tNd7+\u001e9q_J$\u0018AD<sCB<\u0016\u000e\u001e5US6,'o]\u000b\u0005\u0005G\u0014Y\u000f\u0006\u0003\u0003f\nuH\u0003\u0002Bt\u0005[\u0004bA!2\u0003H\n%\b\u0003BA6\u0005W$q!a\u001c0\u0005\u0004\t\t\bC\u0004\u0003p>\u0002\rA!=\u0002\u0007\r$\b\u0010\u0005\u0004\u0003t\ne(\u0011^\u0007\u0003\u0005kTAAa>\u0002\b\u0005A1oY1mC\u0012\u001cH.\u0003\u0003\u0003|\nU(\u0001D!di>\u00148i\u001c8uKb$\bb\u0002Bi_\u0001\u0007!q \t\t\u0003K\u0011)n!\u0001\u0003hB1\u0011Q\u0004Bn\u0005S\u0014\u0011\u0002V5nKJlu\u000eZ3\u0014\u0007A\n\u0019#\u000b\u00031\u0013J\n'A\u0004$jq\u0016$G)\u001a7bs6{G-Z\n\n\u0013\u0006\r2QBA\u001e\u0003\u0003\u00022!!*1\u00031Ig.\u001b;jC2$U\r\\1z+\t\u0019\u0019\u0002\u0005\u0003\u0004\u0016\r}QBAB\f\u0015\u0011\u0019Iba\u0007\u0002\u0011\u0011,(/\u0019;j_:TAa!\b\u0002(\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\r\u00052q\u0003\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00035Ig.\u001b;jC2$U\r\\1zAQ!1qEB\u0015!\r\t)+\u0013\u0005\b\u0007\u001fa\u0005\u0019AB\n)\u0011\u00199c!\f\t\u0013\r=a\n%AA\u0002\rMQCAB\u0019U\u0011\u0019\u0019\"a4\u0015\t\u0005u3Q\u0007\u0005\n\u0005O\u0011\u0016\u0011!a\u0001\u0003\u0017#B!a \u0004:!I!q\u0005+\u0002\u0002\u0003\u0007\u0011Q\f\u000b\u0005\u0005\u001f\u0019i\u0004C\u0005\u0003(U\u000b\t\u00111\u0001\u0002\fR!\u0011qPB!\u0011%\u00119\u0003WA\u0001\u0002\u0004\tiFA\u0007GSb,GMU1uK6{G-Z\n\ne\u0005\r2QBA\u001e\u0003\u0003\"Ba!\u0013\u0004LA\u0019\u0011Q\u0015\u001a\t\u000f\r=Q\u00071\u0001\u0004\u0014Q!1\u0011JB(\u0011%\u0019ya\u000eI\u0001\u0002\u0004\u0019\u0019\u0002\u0006\u0003\u0002^\rM\u0003\"\u0003B\u0014w\u0005\u0005\t\u0019AAF)\u0011\tyha\u0016\t\u0013\t\u001dR(!AA\u0002\u0005uC\u0003\u0002B\b\u00077B\u0011Ba\n?\u0003\u0003\u0005\r!a#\u0015\t\u0005}4q\f\u0005\n\u0005O\t\u0015\u0011!a\u0001\u0003;\u0012!bU5oO2,Wj\u001c3f'%\t\u00171EB\u0007\u0003w\t\t\u0005\u0006\u0002\u0004hA\u0019\u0011QU1\u0015\t\u0005u31\u000e\u0005\n\u0005O1\u0017\u0011!a\u0001\u0003\u0017#B!a \u0004p!I!q\u00055\u0002\u0002\u0003\u0007\u0011QL\u0001\u000e\r&DX\r\u001a*bi\u0016lu\u000eZ3\u0011\u0007\u0005\u00156iE\u0003D\u0007o\u0012I\u0006\u0005\u0005\u0004z\r}41CB%\u001b\t\u0019YH\u0003\u0003\u0004~\u0005\u001d\u0012a\u0002:v]RLW.Z\u0005\u0005\u0007\u0003\u001bYHA\tBEN$(/Y2u\rVt7\r^5p]F\"\"aa\u001d\u0015\t\r%3q\u0011\u0005\b\u0007\u001f1\u0005\u0019AB\n)\u0011\u0019Yi!$\u0011\r\u0005\u0015\"1QB\n\u0011%\u0011\u0019jRA\u0001\u0002\u0004\u0019I%\u0001\bGSb,G\rR3mCflu\u000eZ3\u0011\u0007\u0005\u0015&lE\u0003[\u0007+\u0013I\u0006\u0005\u0005\u0004z\r}41CB\u0014)\t\u0019\t\n\u0006\u0003\u0004(\rm\u0005bBB\b;\u0002\u000711\u0003\u000b\u0005\u0007\u0017\u001by\nC\u0005\u0003\u0014z\u000b\t\u00111\u0001\u0004(\u0005Q1+\u001b8hY\u0016lu\u000eZ3)\u0007\u0005\u0019)\u000b\u0005\u0003\u0004(\u000e-VBABU\u0015\u0011\tY.a\u0004\n\t\r56\u0011\u0016\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eK\u0002\u0001\u0007K+Baa-\u0004>N9A.a\t\u00046\u000e}\u0006C\u0002Bz\u0007o\u001bY,\u0003\u0003\u0004:\nU(A\u0004+j[\u0016\u00148k\u00195fIVdWM\u001d\t\u0005\u0003W\u001ai\fB\u0004\u0002p1\u0014\r!!\u001d\u0011\r\u0005u!1\\B^!\u0019\u0011\u0019P!?\u0004<R!1QYBd!\u0015\ti\u0002\\B^\u0011\u001d\u0011yO\u001ca\u0001\u0007\u0003\fa\u0001^5nKJ\u001cXCABg!!\u0019yma6\u0002^\rug\u0002BBi\u0007'\u0004B!a\u0012\u0002(%!1Q[A\u0014\u0003\u0019\u0001&/\u001a3fM&!1\u0011\\Bn\u0005\ri\u0015\r\u001d\u0006\u0005\u0007+\f9\u0003E\u0003\u0004`\u000e\u0019YLD\u0002\u0002\u001e\u0001\t!\u0002^5nKJ\u001cx\fJ3r)\u0011\u0019)oa;\u0011\t\u0005\u00152q]\u0005\u0005\u0007S\f9C\u0001\u0003V]&$\b\"\u0003B\u0014a\u0006\u0005\t\u0019ABg\u0003\u001d!\u0018.\\3sg\u0002\n\u0001\u0002^5nKJ<UM\\\u000b\u0003\u0007g\u0004bAa\f\u00036\u0005-\u0015!\u0003;j[\u0016\u0014x)\u001a8!\u0003U\u0019H/\u0019:u)&lWM]!u\r&DX\r\u001a*bi\u0016$\u0002b!:\u0004|\u000eu8q \u0005\b\u00033\"\b\u0019AA/\u0011\u001d\t)\u0007\u001ea\u0001\u0007wCq\u0001\"\u0001u\u0001\u0004\u0019\u0019\"\u0001\u0005j]R,'O^1m))\u0019)\u000f\"\u0002\u0005\b\u0011%A1\u0002\u0005\b\u00033*\b\u0019AA/\u0011\u001d\t)'\u001ea\u0001\u0007wCqaa\u0004v\u0001\u0004\u0019\u0019\u0002C\u0004\u0005\u0002U\u0004\raa\u0005\u00021M$\u0018M\u001d;US6,'oV5uQ\u001aK\u00070\u001a3EK2\f\u0017\u0010\u0006\u0005\u0004f\u0012EA1\u0003C\u000b\u0011\u001d\tIF\u001ea\u0001\u0003;Bq!!\u001aw\u0001\u0004\u0019Y\fC\u0004\u0005\u0018Y\u0004\raa\u0005\u0002\u000b\u0011,G.Y=\u0015\u0015\r\u0015H1\u0004C\u000f\t?!\t\u0003C\u0004\u0002Z]\u0004\r!!\u0018\t\u000f\u0005\u0015t\u000f1\u0001\u0004<\"91qB<A\u0002\rM\u0001b\u0002C\fo\u0002\u000711C\u0001\u0013gR\f'\u000f\u001e)fe&|G-[2US6,'\u000f\u0006\u0005\u0004f\u0012\u001dB\u0011\u0006C\u0016\u0011\u001d\tI\u0006\u001fa\u0001\u0003;Bq!!\u001ay\u0001\u0004\u0019Y\fC\u0004\u0005\u0002a\u0004\raa\u0005\u0002!M$\u0018M\u001d;TS:<G.\u001a+j[\u0016\u0014H\u0003CBs\tc!\u0019\u0004\"\u000e\t\u000f\u0005e\u0013\u00101\u0001\u0002^!9\u0011QM=A\u0002\rm\u0006b\u0002C\fs\u0002\u000711C\u0001\u000bgR\f'\u000f\u001e+j[\u0016\u0014HCCBs\tw!i\u0004b\u0010\u0005B!9\u0011\u0011\f>A\u0002\u0005u\u0003bBA3u\u0002\u000711\u0018\u0005\b\t/Q\b\u0019AB\n\u0011\u001d!\u0019E\u001fa\u0001\t\u000b\nA!\\8eKB\u00191q\u001c\u0019\u0002\u001b%\u001cH+[7fe\u0006\u001bG/\u001b<f)\u0011\ty\bb\u0013\t\u000f\u0005e3\u00101\u0001\u0002^\u000511-\u00198dK2$Ba!:\u0005R!9\u0011\u0011\f?A\u0002\u0005u\u0013aC2b]\u000e,G\u000eV5nKJ$Ba!:\u0005X!9A\u0011L?A\u0002\ru\u0017!\u0002;j[\u0016\u0014\u0018!C2b]\u000e,G.\u00117m)\t\u0019)/A\tj]R,'oY3qiRKW.\u001a:Ng\u001e$b\u0001b\u0019\u0005p\u0011}\u0004C\u0002C3\tW\u001aY,\u0004\u0002\u0005h)!A\u0011NA\b\u0003\u0011)H/\u001b7\n\t\u00115Dq\r\u0002\n\u001fB$\u0018n\u001c8WC2Dq\u0001\"\u001d\u0000\u0001\u0004!\u0019(A\u0002m_\u001e\u0004B\u0001\"\u001e\u0005|5\u0011Aq\u000f\u0006\u0005\ts\n9\"A\u0003tY\u001a$$.\u0003\u0003\u0005~\u0011]$A\u0002'pO\u001e,'\u000fC\u0004\u0005\u0002~\u0004\r\u0001b!\u0002\u0011QLW.\u001a:Ng\u001e\u00042aa8&Q\ra7Q\u0015")
@InternalApi
public class TimerSchedulerImpl<T>
implements TimerSchedulerCrossDslSupport<T> {
    private final ActorContext<T> ctx;
    private Map<Object, Timer<T>> timers;
    private final Iterator<Object> timerGen;

    public static <T> Behavior<T> wrapWithTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> factory, ActorContext<T> ctx) {
        if (ctx instanceof ActorContextImpl) {
            TimerSchedulerCrossDslSupport wrapWithTimers_timerScheduler = ((ActorContextImpl)ctx).timer();
            return (Behavior)factory.apply(wrapWithTimers_timerScheduler);
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("timers not supported with [").append(ctx.getClass()).append("]").toString());
    }

    public static <T> Behavior<T> withTimers(Function1<TimerSchedulerCrossDslSupport<T>, Behavior<T>> factory) {
        Function1 & Serializable withTimers_setup_factory = arg_0 -> TimerSchedulerImpl$.$anonfun$withTimers$1(factory, arg_0);
        return new BehaviorImpl.DeferredBehavior<T>(withTimers_setup_factory){
            private final Function1 factory$1;

            public Behavior<T> apply(TypedActorContext<T> ctx) {
                return (Behavior)this.factory$1.apply(ctx.asScala());
            }

            public String toString() {
                return new StringBuilder(10).append("Deferred(").append(LineNumbers$.MODULE$.apply((Object)this.factory$1)).append(")").toString();
            }
            {
                this.factory$1 = factory$1;
            }
        };
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, delay);
    }

    @Override
    public final void startTimerWithFixedDelay(Object key, T msg, Duration initialDelay, Duration delay) {
        TimerSchedulerCrossDslSupport.startTimerWithFixedDelay$(this, key, msg, initialDelay, delay);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, interval);
    }

    @Override
    public final void startTimerAtFixedRate(Object key, T msg, Duration initialDelay, Duration interval) {
        TimerSchedulerCrossDslSupport.startTimerAtFixedRate$(this, key, msg, initialDelay, interval);
    }

    @Override
    public final void startPeriodicTimer(Object key, T msg, Duration interval) {
        TimerSchedulerCrossDslSupport.startPeriodicTimer$(this, key, msg, interval);
    }

    @Override
    public final void startSingleTimer(Object key, T msg, Duration delay) {
        TimerSchedulerCrossDslSupport.startSingleTimer$(this, key, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, Duration initialDelay, Duration delay) {
        TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, Duration initialDelay, Duration interval) {
        TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, Duration delay) {
        TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, delay);
    }

    @Override
    public void startTimerWithFixedDelay(T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerWithFixedDelay$(this, msg, initialDelay, delay);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration interval) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, interval);
    }

    @Override
    public void startTimerAtFixedRate(T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startTimerAtFixedRate$(this, msg, initialDelay, interval);
    }

    @Override
    public void startSingleTimer(T msg, FiniteDuration delay) {
        org.apache.pekko.actor.typed.scaladsl.TimerScheduler.startSingleTimer$(this, msg, delay);
    }

    private Map<Object, Timer<T>> timers() {
        return this.timers;
    }

    private void timers_$eq(Map<Object, Timer<T>> x$1) {
        this.timers = x$1;
    }

    private Iterator<Object> timerGen() {
        return this.timerGen;
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startTimerAtFixedRate(Object key, T msg, FiniteDuration initialDelay, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(initialDelay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(delay));
    }

    @Override
    public void startTimerWithFixedDelay(Object key, T msg, FiniteDuration initialDelay, FiniteDuration delay) {
        this.startTimer(key, msg, delay, new FixedDelayMode(initialDelay));
    }

    @Override
    public void startPeriodicTimer(Object key, T msg, FiniteDuration interval) {
        this.startTimer(key, msg, interval, new FixedRateMode(interval));
    }

    @Override
    public void startSingleTimer(Object key, T msg, FiniteDuration delay) {
        this.startTimer(key, msg, delay, TimerSchedulerImpl$SingleMode$.MODULE$);
    }

    private void startTimer(Object key, T msg, FiniteDuration delay, TimerMode mode) {
        Cancellable cancellable;
        Object timerMsg;
        Option option = this.timers().get(key);
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        int nextGen = BoxesRunTime.unboxToInt((Object)this.timerGen().next());
        Object object = timerMsg = msg instanceof NotInfluenceReceiveTimeout ? new NotInfluenceReceiveTimeout(this, key, nextGen){} : new TimerMsg(key, nextGen, this);
        if (TimerSchedulerImpl$SingleMode$.MODULE$.equals(mode)) {
            cancellable = this.ctx.system().scheduler().scheduleOnce(delay, () -> TimerSchedulerImpl.$anonfun$startTimer$1(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (mode instanceof FixedDelayMode) {
            FixedDelayMode fixedDelayMode = (FixedDelayMode)mode;
            cancellable = this.ctx.system().scheduler().scheduleWithFixedDelay(fixedDelayMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$2(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else if (mode instanceof FixedRateMode) {
            FixedRateMode fixedRateMode = (FixedRateMode)mode;
            cancellable = this.ctx.system().scheduler().scheduleAtFixedRate(fixedRateMode.initialDelay(), delay, () -> TimerSchedulerImpl.$anonfun$startTimer$3(this, (TimerMsg)timerMsg), ExecutionContexts$.MODULE$.parasitic());
        } else {
            throw new MatchError((Object)mode);
        }
        Cancellable task = cancellable;
        Timer<T> nextTimer = new Timer<T>(key, msg, mode.repeat(), nextGen, task);
        this.timers_$eq((Map)this.timers().updated(key, nextTimer));
    }

    @Override
    public boolean isTimerActive(Object key) {
        return this.timers().contains(key);
    }

    @Override
    public void cancel(Object key) {
        Option option = this.timers().get(key);
        if (None$.MODULE$.equals(option)) {
            return;
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            this.cancelTimer(t);
            return;
        }
        throw new MatchError((Object)option);
    }

    private void cancelTimer(Timer<T> timer) {
        timer.task().cancel();
        this.timers_$eq((Map)this.timers().$minus(timer.key()));
    }

    @Override
    public void cancelAll() {
        this.timers().valuesIterator().foreach((Function1 & Serializable)timer -> BoxesRunTime.boxToBoolean((boolean)TimerSchedulerImpl.$anonfun$cancelAll$1(timer)));
        this.timers_$eq(Predef$.MODULE$.Map().empty());
    }

    public T interceptTimerMsg(Logger log, TimerMsg timerMsg) {
        Option option = this.timers().get(timerMsg.key());
        if (None$.MODULE$.equals(option)) {
            log.debug("Received timer [{}] that has been removed, discarding", timerMsg.key());
            return (T)OptionVal$.MODULE$.none();
        }
        if (option instanceof Some) {
            Timer t = (Timer)((Some)option).value();
            if (timerMsg.owner() != this) {
                log.debug("Received timer [{}] from old restarted instance, discarding", timerMsg.key());
                return (T)OptionVal$.MODULE$.none();
            }
            if (timerMsg.generation() == t.generation()) {
                if (!t.repeat()) {
                    this.timers_$eq((Map)this.timers().$minus(t.key()));
                }
                return t.msg();
            }
            if (log.isDebugEnabled()) {
                package$LoggerOps$.MODULE$.debugN$extension(log, "Received timer [{}] from old generation [{}], expected generation [{}], discarding", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{timerMsg.key(), BoxesRunTime.boxToInteger((int)timerMsg.generation()), BoxesRunTime.boxToInteger((int)t.generation())}));
            }
            return (T)OptionVal$.MODULE$.none();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$startTimer$1(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        $this.ctx.self().unsafeUpcast().tell(timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$2(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        $this.ctx.self().unsafeUpcast().tell(timerMsg$1);
    }

    public static final /* synthetic */ void $anonfun$startTimer$3(TimerSchedulerImpl $this, TimerMsg timerMsg$1) {
        $this.ctx.self().unsafeUpcast().tell(timerMsg$1);
    }

    public static final /* synthetic */ boolean $anonfun$cancelAll$1(Timer timer) {
        return timer.task().cancel();
    }

    public TimerSchedulerImpl(ActorContext<T> ctx) {
        this.ctx = ctx;
        this.timers = Predef$.MODULE$.Map().empty();
        this.timerGen = package$.MODULE$.Iterator().from(1);
    }

    private static class FixedDelayMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedDelayMode copy(FiniteDuration initialDelay) {
            return new FixedDelayMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedDelayMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.initialDelay();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedDelayMode;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "initialDelay";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FixedDelayMode)) break block3;
                    FixedDelayMode fixedDelayMode = (FixedDelayMode)x$1;
                    FiniteDuration finiteDuration = this.initialDelay();
                    FiniteDuration finiteDuration2 = fixedDelayMode.initialDelay();
                    if ((finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) || !fixedDelayMode.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FixedDelayMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    private static class FixedRateMode
    implements TimerMode,
    Product,
    Serializable {
        private final FiniteDuration initialDelay;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public FiniteDuration initialDelay() {
            return this.initialDelay;
        }

        @Override
        public boolean repeat() {
            return true;
        }

        public FixedRateMode copy(FiniteDuration initialDelay) {
            return new FixedRateMode(initialDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.initialDelay();
        }

        public String productPrefix() {
            return "FixedRateMode";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.initialDelay();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FixedRateMode;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "initialDelay";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof FixedRateMode)) break block3;
                    FixedRateMode fixedRateMode = (FixedRateMode)x$1;
                    FiniteDuration finiteDuration = this.initialDelay();
                    FiniteDuration finiteDuration2 = fixedRateMode.initialDelay();
                    if ((finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null) || !fixedRateMode.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public FixedRateMode(FiniteDuration initialDelay) {
            this.initialDelay = initialDelay;
            Product.$init$((Product)this);
        }
    }

    public static final class Timer<T>
    implements Product,
    Serializable {
        private final Object key;
        private final T msg;
        private final boolean repeat;
        private final int generation;
        private final Cancellable task;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Object key() {
            return this.key;
        }

        public T msg() {
            return this.msg;
        }

        public boolean repeat() {
            return this.repeat;
        }

        public int generation() {
            return this.generation;
        }

        public Cancellable task() {
            return this.task;
        }

        public <T> Timer<T> copy(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            return new Timer<T>(key, msg, repeat, generation, task);
        }

        public <T> Object copy$default$1() {
            return this.key();
        }

        public <T> T copy$default$2() {
            return this.msg();
        }

        public <T> boolean copy$default$3() {
            return this.repeat();
        }

        public <T> int copy$default$4() {
            return this.generation();
        }

        public <T> Cancellable copy$default$5() {
            return this.task();
        }

        public String productPrefix() {
            return "Timer";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.msg();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.repeat());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.generation());
                }
                case 4: {
                    return this.task();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Timer;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "msg";
                }
                case 2: {
                    return "repeat";
                }
                case 3: {
                    return "generation";
                }
                case 4: {
                    return "task";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"Timer".hashCode()), (int)Statics.anyHash((Object)this.key())), (int)Statics.anyHash(this.msg())), (int)(this.repeat() ? 1231 : 1237)), (int)this.generation()), (int)Statics.anyHash((Object)this.task())), (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof Timer)) break block3;
                    Timer timer = (Timer)x$1;
                    if (this.repeat() != timer.repeat() || this.generation() != timer.generation() || !BoxesRunTime.equals((Object)this.key(), (Object)timer.key()) || !BoxesRunTime.equals(this.msg(), timer.msg())) break block3;
                    Cancellable cancellable = this.task();
                    Cancellable cancellable2 = timer.task();
                    if (cancellable != null ? !cancellable.equals(cancellable2) : cancellable2 != null) break block3;
                }
                return true;
            }
            return false;
        }

        public Timer(Object key, T msg, boolean repeat, int generation, Cancellable task) {
            this.key = key;
            this.msg = msg;
            this.repeat = repeat;
            this.generation = generation;
            this.task = task;
            Product.$init$((Product)this);
        }
    }

    private static interface TimerMode {
        public boolean repeat();
    }

    public static class TimerMsg {
        private final Object key;
        private final int generation;
        private final Object owner;

        public Object key() {
            return this.key;
        }

        public int generation() {
            return this.generation;
        }

        public Object owner() {
            return this.owner;
        }

        public String toString() {
            return new StringBuilder(35).append("TimerMsg(key=").append(this.key()).append(", generation=").append(this.generation()).append(", owner=").append(this.owner()).append(")").toString();
        }

        public TimerMsg(Object key, int generation, Object owner) {
            this.key = key;
            this.generation = generation;
            this.owner = owner;
        }
    }
}

