/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function3;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class BitSet<T extends Number>
extends AbstractField<T>
implements QOM.BitSet<T> {
    final Field<T> value;
    final Field<? extends Number> bit;
    final Field<T> newValue;

    BitSet(Field<T> value, Field<? extends Number> bit) {
        super(Names.N_BIT_SET, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, bit));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.bit = Tools.nullSafeNotNull(bit, SQLDataType.INTEGER);
        this.newValue = null;
    }

    BitSet(Field<T> value, Field<? extends Number> bit, Field<T> newValue) {
        super(Names.N_BIT_SET, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, bit, newValue));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.bit = Tools.nullSafeNotNull(bit, SQLDataType.INTEGER);
        this.newValue = Tools.nullSafeNotNull(newValue, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case CLICKHOUSE: 
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                if (this.newValue == null) {
                    ctx.visit(this.value.bitOr(DSL.one().shl(this.bit)));
                    break;
                }
                ctx.visit(DSL.case_(this.newValue).when((Field<T>)DSL.zero(), this.value.bitAnd(DSL.one().shl(this.bit).bitNot())).when((Field<Integer>)DSL.one(), this.value.bitOr(DSL.one().shl(this.bit))));
                break;
            }
            default: {
                if (this.newValue != null) {
                    ctx.visit(DSL.function(Names.N_BIT_SET, this.getDataType(), this.value, this.bit, this.newValue));
                    break;
                }
                ctx.visit(DSL.function(Names.N_BIT_SET, this.getDataType(), this.value, this.bit));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.bit;
    }

    @Override
    public final Field<T> $arg3() {
        return this.newValue;
    }

    @Override
    public final QOM.BitSet<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<Number>)this.$arg2(), (Field<T>)this.$arg3());
    }

    @Override
    public final QOM.BitSet<T> $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)newValue, (Field<T>)this.$arg3());
    }

    @Override
    public final QOM.BitSet<T> $arg3(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)this.$arg2(), newValue);
    }

    @Override
    public final Function3<? super Field<T>, ? super Field<? extends Number>, ? super Field<T>, ? extends QOM.BitSet<T>> $constructor() {
        return (a1, a2, a3) -> new BitSet(a1, (Field<? extends Number>)((Field<Number>)a2), a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.BitSet) {
            QOM.BitSet o = (QOM.BitSet)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$bit(), o.$bit()) && StringUtils.equals(this.$newValue(), o.$newValue());
        }
        return super.equals(that);
    }
}

