/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.exception;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jooq.exception.SQLStateClass;

public enum SQLStateSubclass {
    C00000_NO_SUBCLASS(SQLStateClass.C00_SUCCESSFUL_COMPLETION, "000"),
    C01000_NO_SUBCLASS(SQLStateClass.C01_WARNING, "000"),
    C01001_CURSOR_OPERATION_CONFLICT(SQLStateClass.C01_WARNING, "001"),
    C01002_DISCONNECT_ERROR(SQLStateClass.C01_WARNING, "002"),
    C01003_NULL_VALUE_ELIMINATED_IN_SET_FUNCTION(SQLStateClass.C01_WARNING, "003"),
    C01004_STRING_DATA_RIGHT_TRUNCATION(SQLStateClass.C01_WARNING, "004"),
    C01005_INSUFFICIENT_ITEM_DESCRIPTOR_AREAS(SQLStateClass.C01_WARNING, "005"),
    C01006_PRIVILEGE_NOT_REVOKED(SQLStateClass.C01_WARNING, "006"),
    C01007_PRIVILEGE_NOT_GRANTED(SQLStateClass.C01_WARNING, "007"),
    C01009_SEARCH_CONDITION_TOO_LONG_FOR_INFORMATION_SCHEMA(SQLStateClass.C01_WARNING, "009"),
    C0100A_QUERY_EXPRESSION_TOO_LONG_FOR_INFORMATION_SCHEMA(SQLStateClass.C01_WARNING, "00A"),
    C0100B_DEFAULT_VALUE_TOO_LONG_FOR_INFORMATION_SCHEMA(SQLStateClass.C01_WARNING, "00B"),
    C0100C_RESULT_SETS_RETURNED(SQLStateClass.C01_WARNING, "00C"),
    C0100D_ADDITIONAL_RESULT_SETS_RETURNED(SQLStateClass.C01_WARNING, "00D"),
    C0100E_ATTEMPT_TO_RETURN_TOO_MANY_RESULT_SETS(SQLStateClass.C01_WARNING, "00E"),
    C0100F_STATEMENT_TOO_LONG_FOR_INFORMATION_SCHEMA(SQLStateClass.C01_WARNING, "00F"),
    C01012_INVALID_NUMBER_OF_CONDITIONS(SQLStateClass.C01_WARNING, "012"),
    C0102F_ARRAY_DATA_RIGHT_TRUNCATION(SQLStateClass.C01_WARNING, "02F"),
    C02000_NO_SUBCLASS(SQLStateClass.C02_NO_DATA, "000"),
    C02001_NO_ADDITIONAL_RESULT_SETS_RETURNED(SQLStateClass.C02_NO_DATA, "001"),
    C07000_NO_SUBCLASS(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "000"),
    C07001_USING_CLAUSE_DOES_NOT_MATCH_DYNAMIC_PARAMETER_SPECIFICATIONS(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "001"),
    C07002_USING_CLAUSE_DOES_NOT_MATCH_TARGET_SPECIFICATIONS(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "002"),
    C07003_CURSOR_SPECIFICATION_CANNOT_BE_EXECUTED(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "003"),
    C07004_USING_CLAUSE_REQUIRED_FOR_DYNAMIC_PARAMETERS(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "004"),
    C07005_PREPARED_STATEMENT_NOT_A_CURSOR_SPECIFICATION(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "005"),
    C07006_RESTRICTED_DATA_TYPE_ATTRIBUTE_VIOLATION(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "006"),
    C07007_USING_CLAUSE_REQUIRED_FOR_RESULT_FIELDS(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "007"),
    C07008_INVALID_DESCRIPTOR_COUNT(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "008"),
    C07009_INVALID_DESCRIPTOR_INDEX(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "009"),
    C0700B_DATA_TYPE_TRANSFORM_FUNCTION_VIOLATION(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "00B"),
    C0700C_UNDEFINED_DATA_VALUE(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "00C"),
    C0700D_INVALID_DATA_TARGET(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "00D"),
    C0700E_INVALID_LEVEL_VALUE(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "00E"),
    C0700F_INVALID_DATETIME_INTERVAL_CODE(SQLStateClass.C07_DYNAMIC_SQL_ERROR, "00F"),
    C08000_NO_SUBCLASS(SQLStateClass.C08_CONNECTION_EXCEPTION, "000"),
    C08001_SQL_CLIENT_UNABLE_TO_ESTABLISH_SQL_CONNECTION(SQLStateClass.C08_CONNECTION_EXCEPTION, "001"),
    C08002_CONNECTION_NAME_IN_USE(SQLStateClass.C08_CONNECTION_EXCEPTION, "002"),
    C08003_CONNECTION_DOES_NOT_EXIST(SQLStateClass.C08_CONNECTION_EXCEPTION, "003"),
    C08004_SQL_SERVER_REJECTED_ESTABLISHMENT_OF_SQL_CONNECTION(SQLStateClass.C08_CONNECTION_EXCEPTION, "004"),
    C08006_CONNECTION_FAILURE(SQLStateClass.C08_CONNECTION_EXCEPTION, "006"),
    C08007_TRANSACTION_RESOLUTION_UNKNOWN(SQLStateClass.C08_CONNECTION_EXCEPTION, "007"),
    C09000_NO_SUBCLASS(SQLStateClass.C09_TRIGGERED_ACTION_EXCEPTION, "000"),
    C0A000_NO_SUBCLASS(SQLStateClass.C0A_FEATURE_NOT_SUPPORTED, "000"),
    C0A001_MULTIPLE_SERVER_TRANSACTIONS(SQLStateClass.C0A_FEATURE_NOT_SUPPORTED, "001"),
    C0D000_NO_SUBCLASS(SQLStateClass.C0D_INVALID_TARGET_TYPE_SPECIFICATION, "000"),
    C0E000_NO_SUBCLASS(SQLStateClass.C0E_INVALID_SCHEMA_NAME_LIST_SPECIFICATION, "000"),
    C0F000_NO_SUBCLASS(SQLStateClass.C0F_LOCATOR_EXCEPTION, "000"),
    C0F001_INVALID_SPECIFICATION(SQLStateClass.C0F_LOCATOR_EXCEPTION, "001"),
    C0L000_NO_SUBCLASS(SQLStateClass.C0L_INVALID_GRANTOR, "000"),
    C0M000_NO_SUBCLASS(SQLStateClass.C0M_INVALID_SQL_INVOKED_PROCEDURE_REFERENCE, "000"),
    C0P000_NO_SUBCLASS(SQLStateClass.C0P_INVALID_ROLE_SPECIFICATION, "000"),
    C0S000_NO_SUBCLASS(SQLStateClass.C0S_INVALID_TRANSFORM_GROUP_NAME_SPECIFICATION, "000"),
    C0T000_NO_SUBCLASS(SQLStateClass.C0T_TARGET_TABLE_DISAGREES_WITH_CURSOR_SPECIFICATION, "000"),
    C0U000_NO_SUBCLASS(SQLStateClass.C0U_ATTEMPT_TO_ASSIGN_TO_NON_UPDATABLE_COLUMN, "000"),
    C0V000_NO_SUBCLASS(SQLStateClass.C0V_ATTEMPT_TO_ASSIGN_TO_ORDERING_COLUMN, "000"),
    C0W000_NO_SUBCLASS(SQLStateClass.C0W_PROHIBITED_STATEMENT_ENCOUNTERED_DURING_TRIGGER_EXECUTION, "000"),
    C0W001_MODIFY_TABLE_MODIFIED_BY_DATA_CHANGE_DELTA_TABLE(SQLStateClass.C0W_PROHIBITED_STATEMENT_ENCOUNTERED_DURING_TRIGGER_EXECUTION, "001"),
    C0Z000_NO_SUBCLASS(SQLStateClass.C0Z_DIAGNOSTICS_EXCEPTION, "000"),
    C0Z001_MAXIMUM_NUMBER_OF_STACKED_DIAGNOSTICS_AREAS_EXCEEDED(SQLStateClass.C0Z_DIAGNOSTICS_EXCEPTION, "001"),
    C21000_NO_SUBCLASS(SQLStateClass.C21_CARDINALITY_VIOLATION, "000"),
    C22000_NO_SUBCLASS(SQLStateClass.C22_DATA_EXCEPTION, "000"),
    C22001_STRING_DATA_RIGHT_TRUNCATION(SQLStateClass.C22_DATA_EXCEPTION, "001"),
    C22002_NULL_VALUE_NO_INDICATOR_PARAMETER(SQLStateClass.C22_DATA_EXCEPTION, "002"),
    C22003_NUMERIC_VALUE_OUT_OF_RANGE(SQLStateClass.C22_DATA_EXCEPTION, "003"),
    C22004_NULL_VALUE_NOT_ALLOWED(SQLStateClass.C22_DATA_EXCEPTION, "004"),
    C22005_ERROR_IN_ASSIGNMENT(SQLStateClass.C22_DATA_EXCEPTION, "005"),
    C22006_INVALID_INTERVAL_FORMAT(SQLStateClass.C22_DATA_EXCEPTION, "006"),
    C22007_INVALID_DATETIME_FORMAT(SQLStateClass.C22_DATA_EXCEPTION, "007"),
    C22008_DATETIME_FIELD_OVERFLOW(SQLStateClass.C22_DATA_EXCEPTION, "008"),
    C22009_INVALID_TIME_ZONE_DISPLACEMENT_VALUE(SQLStateClass.C22_DATA_EXCEPTION, "009"),
    C2200B_ESCAPE_CHARACTER_CONFLICT(SQLStateClass.C22_DATA_EXCEPTION, "00B"),
    C2200C_INVALID_USE_OF_ESCAPE_CHARACTER(SQLStateClass.C22_DATA_EXCEPTION, "00C"),
    C2200D_INVALID_ESCAPE_OCTET(SQLStateClass.C22_DATA_EXCEPTION, "00D"),
    C2200E_NULL_VALUE_IN_ARRAY_TARGET(SQLStateClass.C22_DATA_EXCEPTION, "00E"),
    C2200F_ZERO_LENGTH_CHARACTER_STRING(SQLStateClass.C22_DATA_EXCEPTION, "00F"),
    C2200G_MOST_SPECIFIC_TYPE_MISMATCH(SQLStateClass.C22_DATA_EXCEPTION, "00G"),
    C2200H_SEQUENCE_GENERATOR_LIMIT_EXCEEDED(SQLStateClass.C22_DATA_EXCEPTION, "00H"),
    C2200P_INTERVAL_VALUE_OUT_OF_RANGE(SQLStateClass.C22_DATA_EXCEPTION, "00P"),
    C2200Q_MULTISET_VALUE_OVERFLOW(SQLStateClass.C22_DATA_EXCEPTION, "00Q"),
    C22010_INVALID_INDICATOR_PARAMETER_VALUE(SQLStateClass.C22_DATA_EXCEPTION, "010"),
    C22011_SUBSTRING_ERROR(SQLStateClass.C22_DATA_EXCEPTION, "011"),
    C22012_DIVISION_BY_ZERO(SQLStateClass.C22_DATA_EXCEPTION, "012"),
    C22013_INVALID_PRECEDING_OR_FOLLOWING_SIZE_IN_WINDOW_FUNCTION(SQLStateClass.C22_DATA_EXCEPTION, "013"),
    C22014_INVALID_ARGUMENT_FOR_NTILE_FUNCTION(SQLStateClass.C22_DATA_EXCEPTION, "014"),
    C22015_INTERVAL_FIELD_OVERFLOW(SQLStateClass.C22_DATA_EXCEPTION, "015"),
    C22016_INVALID_ARGUMENT_FOR_NTH_VALUE_FUNCTION(SQLStateClass.C22_DATA_EXCEPTION, "016"),
    C22018_INVALID_CHARACTER_VALUE_FOR_CAST(SQLStateClass.C22_DATA_EXCEPTION, "018"),
    C22019_INVALID_ESCAPE_CHARACTER(SQLStateClass.C22_DATA_EXCEPTION, "019"),
    C2201B_INVALID_REGULAR_EXPRESSION(SQLStateClass.C22_DATA_EXCEPTION, "01B"),
    C2201C_NULL_ROW_NOT_PERMITTED_IN_TABLE(SQLStateClass.C22_DATA_EXCEPTION, "01C"),
    C2201E_INVALID_ARGUMENT_FOR_NATURAL_LOGARITHM(SQLStateClass.C22_DATA_EXCEPTION, "01E"),
    C2201F_INVALID_ARGUMENT_FOR_POWER_FUNCTION(SQLStateClass.C22_DATA_EXCEPTION, "01F"),
    C2201G_INVALID_ARGUMENT_FOR_WIDTH_BUCKET_FUNCTION(SQLStateClass.C22_DATA_EXCEPTION, "01G"),
    C2201H_INVALID_ROW_VERSION(SQLStateClass.C22_DATA_EXCEPTION, "01H"),
    C2201S_INVALID_XQUERY_REGULAR_EXPRESSION(SQLStateClass.C22_DATA_EXCEPTION, "01S"),
    C2201T_INVALID_XQUERY_OPTION_FLAG(SQLStateClass.C22_DATA_EXCEPTION, "01T"),
    C2201U_ATTEMPT_TO_REPLACE_A_ZERO_LENGTH_STRING(SQLStateClass.C22_DATA_EXCEPTION, "01U"),
    C2201V_INVALID_XQUERY_REPLACEMENT_STRING(SQLStateClass.C22_DATA_EXCEPTION, "01V"),
    C2201W_INVALID_ROW_COUNT_IN_FETCH_FIRST_CLAUSE(SQLStateClass.C22_DATA_EXCEPTION, "01W"),
    C2201X_INVALID_ROW_COUNT_IN_RESULT_OFFSET_CLAUSE(SQLStateClass.C22_DATA_EXCEPTION, "01X"),
    C22020_INVALID_PERIOD_VALUE(SQLStateClass.C22_DATA_EXCEPTION, "020"),
    C22021_CHARACTER_NOT_IN_REPERTOIRE(SQLStateClass.C22_DATA_EXCEPTION, "021"),
    C22022_INDICATOR_OVERFLOW(SQLStateClass.C22_DATA_EXCEPTION, "022"),
    C22023_INVALID_PARAMETER_VALUE(SQLStateClass.C22_DATA_EXCEPTION, "023"),
    C22024_UNTERMINATED_C_STRING(SQLStateClass.C22_DATA_EXCEPTION, "024"),
    C22025_INVALID_ESCAPE_SEQUENCE(SQLStateClass.C22_DATA_EXCEPTION, "025"),
    C22026_STRING_DATA_LENGTH_MISMATCH(SQLStateClass.C22_DATA_EXCEPTION, "026"),
    C22027_TRIM_ERROR(SQLStateClass.C22_DATA_EXCEPTION, "027"),
    C22029_NONCHARACTER_IN_UCS_STRING(SQLStateClass.C22_DATA_EXCEPTION, "029"),
    C2202D_NULL_VALUE_SUBSTITUTED_FOR_MUTATOR_SUBJECT_PARAMETER(SQLStateClass.C22_DATA_EXCEPTION, "02D"),
    C2202E_ARRAY_ELEMENT_ERROR(SQLStateClass.C22_DATA_EXCEPTION, "02E"),
    C2202F_ARRAY_DATA_RIGHT_TRUNCATION(SQLStateClass.C22_DATA_EXCEPTION, "02F"),
    C2202G_INVALID_REPEAT_ARGUMENT_IN_SAMPLE_CLAUSE(SQLStateClass.C22_DATA_EXCEPTION, "02G"),
    C2202H_INVALID_SAMPLE_SIZE(SQLStateClass.C22_DATA_EXCEPTION, "02H"),
    C23000_NO_SUBCLASS(SQLStateClass.C23_INTEGRITY_CONSTRAINT_VIOLATION, "000"),
    C23001_RESTRICT_VIOLATION(SQLStateClass.C23_INTEGRITY_CONSTRAINT_VIOLATION, "001"),
    C24000_NO_SUBCLASS(SQLStateClass.C24_INVALID_CURSOR_STATE, "000"),
    C25000_NO_SUBCLASS(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "000"),
    C25001_ACTIVE_SQL_TRANSACTION(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "001"),
    C25002_BRANCH_TRANSACTION_ALREADY_ACTIVE(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "002"),
    C25003_INAPPROPRIATE_ACCESS_MODE_FOR_BRANCH_TRANSACTION(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "003"),
    C25004_INAPPROPRIATE_ISOLATION_LEVEL_FOR_BRANCH_TRANSACTION(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "004"),
    C25005_NO_ACTIVE_SQL_TRANSACTION_FOR_BRANCH_TRANSACTION(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "005"),
    C25006_READ_ONLY_SQL_TRANSACTION(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "006"),
    C25007_SCHEMA_AND_DATA_STATEMENT_MIXING_NOT_SUPPORTED(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "007"),
    C25008_HELD_CURSOR_REQUIRES_SAME_ISOLATION_LEVEL(SQLStateClass.C25_INVALID_TRANSACTION_STATE, "008"),
    C26000_NO_SUBCLASS(SQLStateClass.C26_INVALID_SQL_STATEMENT_NAME, "000"),
    C27000_NO_SUBCLASS(SQLStateClass.C27_TRIGGERED_DATA_CHANGE_VIOLATION, "000"),
    C27001_MODIFY_TABLE_MODIFIED_BY_DATA_CHANGE_DELTA_TABLE(SQLStateClass.C27_TRIGGERED_DATA_CHANGE_VIOLATION, "001"),
    C28000_NO_SUBCLASS(SQLStateClass.C28_INVALID_AUTHORIZATION_SPECIFICATION, "000"),
    C2B000_NO_SUBCLASS(SQLStateClass.C2B_DEPENDENT_PRIVILEGE_DESCRIPTORS_STILL_EXIST, "000"),
    C2C000_NO_SUBCLASS(SQLStateClass.C2C_INVALID_CHARACTER_SET_NAME, "000"),
    C2C001_CANNOT_DROP_SQL_SESSION_DEFAULT_CHARACTER_SET(SQLStateClass.C2C_INVALID_CHARACTER_SET_NAME, "001"),
    C2D000_NO_SUBCLASS(SQLStateClass.C2D_INVALID_TRANSACTION_TERMINATION, "000"),
    C2E000_NO_SUBCLASS(SQLStateClass.C2E_INVALID_CONNECTION_NAME, "000"),
    C2F000_NO_SUBCLASS(SQLStateClass.C2F_SQL_ROUTINE_EXCEPTION, "000"),
    C2F002_MODIFYING_SQL_DATA_NOT_PERMITTED(SQLStateClass.C2F_SQL_ROUTINE_EXCEPTION, "002"),
    C2F003_PROHIBITED_SQL_STATEMENT_ATTEMPTED(SQLStateClass.C2F_SQL_ROUTINE_EXCEPTION, "003"),
    C2F004_READING_SQL_DATA_NOT_PERMITTED(SQLStateClass.C2F_SQL_ROUTINE_EXCEPTION, "004"),
    C2F005_FUNCTION_EXECUTED_NO_RETURN_STATEMENT(SQLStateClass.C2F_SQL_ROUTINE_EXCEPTION, "005"),
    C2H000_NO_SUBCLASS(SQLStateClass.C2H_INVALID_COLLATION_NAME, "000"),
    C30000_NO_SUBCLASS(SQLStateClass.C30_INVALID_SQL_STATEMENT_IDENTIFIER, "000"),
    C33000_NO_SUBCLASS(SQLStateClass.C33_INVALID_SQL_DESCRIPTOR_NAME, "000"),
    C34000_NO_SUBCLASS(SQLStateClass.C34_INVALID_CURSOR_NAME, "000"),
    C35000_NO_SUBCLASS(SQLStateClass.C35_INVALID_CONDITION_NUMBER, "000"),
    C36000_NO_SUBCLASS(SQLStateClass.C36_CURSOR_SENSITIVITY_EXCEPTION, "000"),
    C36001_REQUEST_REJECTED(SQLStateClass.C36_CURSOR_SENSITIVITY_EXCEPTION, "001"),
    C36002_REQUEST_FAILED(SQLStateClass.C36_CURSOR_SENSITIVITY_EXCEPTION, "002"),
    C38000_NO_SUBCLASS(SQLStateClass.C38_EXTERNAL_ROUTINE_EXCEPTION, "000"),
    C38001_CONTAINING_SQL_NOT_PERMITTED(SQLStateClass.C38_EXTERNAL_ROUTINE_EXCEPTION, "001"),
    C38002_MODIFYING_SQL_DATA_NOT_PERMITTED(SQLStateClass.C38_EXTERNAL_ROUTINE_EXCEPTION, "002"),
    C38003_PROHIBITED_SQL_STATEMENT_ATTEMPTED(SQLStateClass.C38_EXTERNAL_ROUTINE_EXCEPTION, "003"),
    C38004_READING_SQL_DATA_NOT_PERMITTED(SQLStateClass.C38_EXTERNAL_ROUTINE_EXCEPTION, "004"),
    C39000_NO_SUBCLASS(SQLStateClass.C39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION, "000"),
    C39004_NULL_VALUE_NOT_ALLOWED(SQLStateClass.C39_EXTERNAL_ROUTINE_INVOCATION_EXCEPTION, "004"),
    C3B000_NO_SUBCLASS(SQLStateClass.C3B_SAVEPOINT_EXCEPTION, "000"),
    C3B001_INVALID_SPECIFICATION(SQLStateClass.C3B_SAVEPOINT_EXCEPTION, "001"),
    C3B002_TOO_MANY(SQLStateClass.C3B_SAVEPOINT_EXCEPTION, "002"),
    C3C000_NO_SUBCLASS(SQLStateClass.C3C_AMBIGUOUS_CURSOR_NAME, "000"),
    C3D000_NO_SUBCLASS(SQLStateClass.C3D_INVALID_CATALOG_NAME, "000"),
    C3F000_NO_SUBCLASS(SQLStateClass.C3F_INVALID_SCHEMA_NAME, "000"),
    C40000_NO_SUBCLASS(SQLStateClass.C40_TRANSACTION_ROLLBACK, "000"),
    C40001_SERIALIZATION_FAILURE(SQLStateClass.C40_TRANSACTION_ROLLBACK, "001"),
    C40002_INTEGRITY_CONSTRAINT_VIOLATION(SQLStateClass.C40_TRANSACTION_ROLLBACK, "002"),
    C40003_STATEMENT_COMPLETION_UNKNOWN(SQLStateClass.C40_TRANSACTION_ROLLBACK, "003"),
    C40004_TRIGGERED_ACTION_EXCEPTION(SQLStateClass.C40_TRANSACTION_ROLLBACK, "004"),
    C42000_NO_SUBCLASS(SQLStateClass.C42_SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION, "000"),
    CHZ000_NO_SUBCLASS(SQLStateClass.CHZ_REMOTE_DATABASE_ACCESS, "000"),
    OTHER(SQLStateClass.OTHER, ""),
    NONE(SQLStateClass.OTHER, "");

    private static final Map<String, SQLStateSubclass> lookup;
    private final SQLStateClass clazz;
    private final String subclass;

    private SQLStateSubclass(SQLStateClass clazz, String subclass) {
        this.clazz = clazz;
        this.subclass = subclass;
    }

    @NotNull
    public String sqlStateSubclassName() {
        return this.subclass;
    }

    @NotNull
    public SQLStateClass sqlStateClass() {
        return this.clazz;
    }

    @NotNull
    public String sqlStateClassName() {
        return this.sqlStateClass().className();
    }

    @NotNull
    public static SQLStateSubclass fromCode(String code) {
        if (code == null || code.length() != 5) {
            return OTHER;
        }
        SQLStateSubclass result = lookup.get(code);
        if (result != null) {
            return result;
        }
        result = lookup.get(code.substring(0, 2) + "000");
        if (result != null) {
            return result;
        }
        return OTHER;
    }

    @NotNull
    static SQLStateSubclass fromSQLiteVendorCode(int errorCode) {
        switch (errorCode & 0xFF) {
            case 0: {
                return C00000_NO_SUBCLASS;
            }
            case 3: {
                return C42000_NO_SUBCLASS;
            }
            case 18: {
                return C22001_STRING_DATA_RIGHT_TRUNCATION;
            }
            case 19: {
                return C23000_NO_SUBCLASS;
            }
            case 20: {
                return C22000_NO_SUBCLASS;
            }
            case 27: {
                return C01000_NO_SUBCLASS;
            }
            case 28: {
                return C01000_NO_SUBCLASS;
            }
        }
        return OTHER;
    }

    static {
        lookup = new HashMap<String, SQLStateSubclass>();
        for (SQLStateSubclass clazz : SQLStateSubclass.values()) {
            lookup.put(clazz.sqlStateClassName() + clazz.subclass, clazz);
        }
    }
}

