/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import jakarta.mail.MessagingException;
import java.time.Duration;
import java.util.List;
import org.apache.james.transport.mailets.remote.delivery.Repeat;
import org.apache.james.util.DurationParser;

public class Delay {
    public static final Duration DEFAULT_DELAY_TIME = Duration.ofHours(6L);
    public static final int DEFAULT_ATTEMPTS = 1;
    private final int attempts;
    private final Duration delayTime;

    public static Delay from(String initString) throws MessagingException {
        if (Strings.isNullOrEmpty((String)initString)) {
            throw new NumberFormatException("Null or Empty strings are not permitted");
        }
        List parts = Splitter.on((char)'*').trimResults().splitToList((CharSequence)initString);
        if (parts.size() == 1) {
            return new Delay(1, DurationParser.parse((String)((String)parts.get(0))));
        }
        if (parts.size() == 2) {
            int attempts = Integer.parseInt((String)parts.get(0));
            if (attempts < 0) {
                throw new MessagingException("Number of attempts negative in " + initString);
            }
            return new Delay(attempts, DurationParser.parse((String)((String)parts.get(1))));
        }
        throw new MessagingException(initString + " contains too much parts");
    }

    public Delay() {
        this(1, DEFAULT_DELAY_TIME);
    }

    Delay(int attempts, Duration delayTime) {
        this.attempts = attempts;
        this.delayTime = delayTime;
    }

    public Duration getDelayTime() {
        return this.delayTime;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public List<Duration> getExpendendDelays() {
        return Repeat.repeat(this.delayTime, this.attempts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attempts", this.attempts).add("delayTime", (Object)this.delayTime).toString();
    }

    public boolean equals(Object o) {
        if (o instanceof Delay) {
            Delay that = (Delay)o;
            return Objects.equal((Object)this.attempts, (Object)that.attempts) && Objects.equal((Object)this.delayTime, (Object)that.delayTime);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attempts, this.delayTime});
    }
}

