/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.impl.jmx.MailProcessorManagement;
import org.apache.james.mailetcontainer.lib.AbstractStateCompositeProcessor;

public class JMXStateCompositeProcessorListener
implements AbstractStateCompositeProcessor.CompositeProcessorListener,
Disposable {
    private final AbstractStateCompositeProcessor mList;
    private final MBeanServer mbeanserver;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private final Map<MailProcessor, MailProcessorManagement> mMap = new HashMap<MailProcessor, MailProcessorManagement>();

    public JMXStateCompositeProcessorListener(AbstractStateCompositeProcessor mList) throws JMException {
        this.mList = mList;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        this.registerMBeans();
    }

    private void unregisterMBeans() {
        ArrayList<ObjectName> unregistered = new ArrayList<ObjectName>();
        for (ObjectName name : this.mbeans) {
            try {
                this.mbeanserver.unregisterMBean(name);
                unregistered.add(name);
            }
            catch (JMException jMException) {}
        }
        this.mbeans.removeAll(unregistered);
    }

    private void registerMBeans() throws JMException {
        String[] processorNames;
        String baseObjectName = "org.apache.james:type=component,component=mailetcontainer,name=processor,";
        for (String processorName : processorNames = this.mList.getProcessorStates()) {
            this.registerProcessorMBean(baseObjectName, processorName);
        }
    }

    private void registerProcessorMBean(String baseObjectName, String processorName) throws JMException {
        String processorMBeanName = baseObjectName + "processor=" + processorName;
        MailProcessorManagement processorDetail = new MailProcessorManagement(processorName);
        this.registerMBean(processorMBeanName, processorDetail);
        this.mMap.put(this.mList.getProcessor(processorName), processorDetail);
    }

    private void registerMBean(String mBeanName, Object object) throws JMException {
        ObjectName objectName = new ObjectName(mBeanName);
        this.mbeanserver.registerMBean(object, objectName);
        this.mbeans.add(objectName);
    }

    @Override
    public void afterProcessor(MailProcessor processor, String mailName, long processTime, MessagingException e) {
        MailProcessorManagement m = this.mMap.get(processor);
        if (m != null) {
            m.update(processTime, e == null);
        }
    }

    public void dispose() {
        this.unregisterMBeans();
        this.mMap.clear();
    }
}

