/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.RecentLoginHistoryAttempt;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RecentLoginHistory
implements Serializable {
    @NotNull
    private static final String JSON_FIELD_FAILED_ATTEMPTS = "failed-attempts";
    @NotNull
    private static final String JSON_FIELD_SUCCESSFUL_ATTEMPTS = "successful-attempts";
    private static final long serialVersionUID = -5692706886656940486L;
    @NotNull
    private final JSONObject jsonObject;
    @NotNull
    private final SortedSet<RecentLoginHistoryAttempt> failedAttempts;
    @NotNull
    private final SortedSet<RecentLoginHistoryAttempt> successfulAttempts;

    public RecentLoginHistory(@Nullable Collection<RecentLoginHistoryAttempt> successfulAttempts, @Nullable Collection<RecentLoginHistoryAttempt> failedAttempts) {
        ArrayList<JSONObject> successValues = new ArrayList<JSONObject>();
        TreeSet<RecentLoginHistoryAttempt> successes = new TreeSet<RecentLoginHistoryAttempt>();
        if (successfulAttempts != null) {
            for (RecentLoginHistoryAttempt a : successfulAttempts) {
                successes.add(a);
                successValues.add(a.asJSONObject());
            }
        }
        this.successfulAttempts = Collections.unmodifiableSortedSet(successes);
        ArrayList<JSONObject> failureValues = new ArrayList<JSONObject>();
        TreeSet<RecentLoginHistoryAttempt> failures = new TreeSet<RecentLoginHistoryAttempt>();
        if (failedAttempts != null) {
            for (RecentLoginHistoryAttempt a : failedAttempts) {
                failures.add(a);
                failureValues.add(a.asJSONObject());
            }
        }
        this.failedAttempts = Collections.unmodifiableSortedSet(failures);
        this.jsonObject = new JSONObject(new JSONField(JSON_FIELD_SUCCESSFUL_ATTEMPTS, new JSONArray(successValues)), new JSONField(JSON_FIELD_FAILED_ATTEMPTS, new JSONArray(failureValues)));
    }

    public RecentLoginHistory(@NotNull JSONObject jsonObject) throws LDAPException {
        Validator.ensureNotNull(jsonObject, "RecentLoginHistory.<init>.jsonObject must not be null.");
        this.jsonObject = jsonObject;
        TreeSet<RecentLoginHistoryAttempt> successes = new TreeSet<RecentLoginHistoryAttempt>();
        List<JSONValue> successValues = jsonObject.getFieldAsArray(JSON_FIELD_SUCCESSFUL_ATTEMPTS);
        if (successValues != null) {
            for (JSONValue v : successValues) {
                try {
                    successes.add(new RecentLoginHistoryAttempt((JSONObject)v));
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_CANNOT_PARSE_SUCCESS.get(jsonObject.toSingleLineString(), e.getMessage()), e);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_CANNOT_PARSE_SUCCESS.get(jsonObject.toSingleLineString(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
        }
        TreeSet<RecentLoginHistoryAttempt> failures = new TreeSet<RecentLoginHistoryAttempt>();
        List<JSONValue> failureValues = jsonObject.getFieldAsArray(JSON_FIELD_FAILED_ATTEMPTS);
        if (failureValues != null) {
            for (JSONValue v : failureValues) {
                try {
                    failures.add(new RecentLoginHistoryAttempt((JSONObject)v));
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_CANNOT_PARSE_FAILURE.get(jsonObject.toSingleLineString(), e.getMessage()), e);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_RECENT_LOGIN_HISTORY_CANNOT_PARSE_FAILURE.get(jsonObject.toSingleLineString(), StaticUtils.getExceptionMessage(e)), e);
                }
            }
        }
        this.successfulAttempts = Collections.unmodifiableSortedSet(successes);
        this.failedAttempts = Collections.unmodifiableSortedSet(failures);
    }

    @NotNull
    public SortedSet<RecentLoginHistoryAttempt> getSuccessfulAttempts() {
        return this.successfulAttempts;
    }

    @NotNull
    public SortedSet<RecentLoginHistoryAttempt> getFailedAttempts() {
        return this.failedAttempts;
    }

    @NotNull
    public JSONObject asJSONObject() {
        return this.jsonObject;
    }

    @NotNull
    public String toString() {
        return this.jsonObject.toSingleLineString();
    }
}

