/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.core.server.QueueQueryResult;

public class SessionQueueQueryResponseMessage_V2
extends SessionQueueQueryResponseMessage {
    protected boolean autoCreateQueues;

    public SessionQueueQueryResponseMessage_V2(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists(), result.isAutoCreateQueues());
    }

    public SessionQueueQueryResponseMessage_V2() {
        this(null, null, false, false, null, 0, 0L, false, false);
    }

    private SessionQueueQueryResponseMessage_V2(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists, boolean autoCreateQueues) {
        super((byte)-7);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
        this.autoCreateQueues = autoCreateQueues;
    }

    public SessionQueueQueryResponseMessage_V2(byte v) {
        super(v);
    }

    public boolean isAutoCreateQueues() {
        return this.autoCreateQueues;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeBoolean(this.autoCreateQueues);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.autoCreateQueues = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoCreateQueues ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", autoCreationEnabled=" + this.autoCreateQueues);
        return buff.toString();
    }

    @Override
    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists(), this.isAutoCreateQueues());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage_V2)) {
            return false;
        }
        SessionQueueQueryResponseMessage_V2 other = (SessionQueueQueryResponseMessage_V2)obj;
        return this.autoCreateQueues == other.autoCreateQueues;
    }
}

