/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.QueueQueryImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.QueueQueryResult;

public class SessionQueueQueryResponseMessage
extends PacketImpl {
    protected SimpleString name;
    protected boolean exists;
    protected boolean durable;
    protected int consumerCount;
    protected long messageCount;
    protected SimpleString filterString;
    protected SimpleString address;
    protected boolean temporary;

    public SessionQueueQueryResponseMessage(QueueQueryResult result) {
        this(result.getName(), result.getAddress(), result.isDurable(), result.isTemporary(), result.getFilterString(), result.getConsumerCount(), result.getMessageCount(), result.isExists());
    }

    public SessionQueueQueryResponseMessage() {
        this(null, null, false, false, null, 0, 0L, false);
    }

    public SessionQueueQueryResponseMessage(byte v) {
        super(v);
    }

    private SessionQueueQueryResponseMessage(SimpleString name, SimpleString address, boolean durable, boolean temporary, SimpleString filterString, int consumerCount, long messageCount, boolean exists) {
        super((byte)46);
        this.durable = durable;
        this.temporary = temporary;
        this.consumerCount = consumerCount;
        this.messageCount = messageCount;
        this.filterString = filterString;
        this.address = address;
        this.name = name;
        this.exists = exists;
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public boolean isExists() {
        return this.exists;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public long getMessageCount() {
        return this.messageCount;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeBoolean(this.exists);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeInt(this.consumerCount);
        buffer.writeLong(this.messageCount);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeNullableSimpleString(this.address);
        buffer.writeNullableSimpleString(this.name);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.exists = buffer.readBoolean();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.consumerCount = buffer.readInt();
        this.messageCount = buffer.readLong();
        this.filterString = buffer.readNullableSimpleString();
        this.address = buffer.readNullableSimpleString();
        this.name = buffer.readNullableSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.consumerCount;
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + (this.exists ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (int)(this.messageCount ^ this.messageCount >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.temporary ? 1231 : 1237);
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", address=" + this.address);
        buff.append(", name=" + this.name);
        buff.append(", consumerCount=" + this.consumerCount);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", exists=" + this.exists);
        buff.append(", temporary=" + this.temporary);
        buff.append(", messageCount=" + this.messageCount);
        return buff.toString();
    }

    public ClientSession.QueueQuery toQueueQuery() {
        return new QueueQueryImpl(this.isDurable(), this.isTemporary(), this.getConsumerCount(), this.getMessageCount(), this.getFilterString(), this.getAddress(), this.getName(), this.isExists());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryResponseMessage)) {
            return false;
        }
        SessionQueueQueryResponseMessage other = (SessionQueueQueryResponseMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        if (this.consumerCount != other.consumerCount) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.exists != other.exists) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals((Object)other.filterString)) {
            return false;
        }
        if (this.messageCount != other.messageCount) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        return this.temporary == other.temporary;
    }
}

