/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;

class RowOrderingImpl
implements RowOrdering {
    private final ArrayList<ColumnOrdering> ordering = new ArrayList();
    ColumnOrdering columnsAlwaysOrdered;
    private final ArrayList<Optimizable> alwaysOrderedOptimizables = new ArrayList();
    ColumnOrdering currentColumnOrdering;
    private final ArrayList<Optimizable> unorderedOptimizables = new ArrayList();

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
    }

    @Override
    public boolean isColumnAlwaysOrdered(int n, int n2) {
        return this.columnsAlwaysOrdered.contains(n, n2);
    }

    @Override
    public boolean orderedOnColumn(int n, int n2, int n3, int n4) throws StandardException {
        if (this.alwaysOrdered(n3)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n3, n4)) {
            return true;
        }
        if (n2 >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering columnOrdering = this.ordering.get(n2);
        return columnOrdering.ordered(n, n3, n4);
    }

    @Override
    public boolean orderedOnColumn(int n, int n2, int n3) throws StandardException {
        if (this.alwaysOrdered(n2)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(n2, n3)) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering columnOrdering = this.ordering.get(i);
            boolean bl2 = columnOrdering.ordered(n, n2, n3);
            if (!bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void addOrderedColumn(int n, int n2, int n3) {
        ColumnOrdering columnOrdering;
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        if (this.ordering.isEmpty()) {
            columnOrdering = new ColumnOrdering(n);
            this.ordering.add(columnOrdering);
        } else {
            columnOrdering = this.ordering.get(this.ordering.size() - 1);
        }
        columnOrdering.addColumn(n2, n3);
    }

    @Override
    public void nextOrderPosition(int n) {
        if (!this.unorderedOptimizables.isEmpty()) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(n);
        this.ordering.add(this.currentColumnOrdering);
    }

    @Override
    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int n;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean bl = optimizable.hasTableNumber();
        int n2 = n = bl ? optimizable.getTableNumber() : 0;
        if ((this.ordering.isEmpty() || bl && this.ordering.get(0).hasTable(n)) && bl && !this.columnsAlwaysOrdered.hasAnyOtherTable(n)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.add(optimizable);
        }
    }

    @Override
    public void columnAlwaysOrdered(Optimizable optimizable, int n) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), n);
    }

    @Override
    public boolean alwaysOrdered(int n) {
        for (Optimizable optimizable : this.alwaysOrderedOptimizables) {
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeOptimizable(int n) {
        for (int i = this.ordering.size() - 1; i >= 0; --i) {
            ColumnOrdering columnOrdering = this.ordering.get(i);
            columnOrdering.removeColumns(n);
            if (!columnOrdering.empty()) continue;
            this.ordering.remove(i);
        }
        this.columnsAlwaysOrdered.removeColumns(n);
        this.removeOptimizable(n, this.unorderedOptimizables);
        this.removeOptimizable(n, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizable(int n, ArrayList<Optimizable> arrayList) {
        ListIterator<Optimizable> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            Optimizable optimizable = listIterator.next();
            if (!optimizable.hasTableNumber() || optimizable.getTableNumber() != n) continue;
            listIterator.remove();
        }
    }

    @Override
    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.add(optimizable);
    }

    @Override
    public void copy(RowOrdering rowOrdering) {
        int n;
        RowOrderingImpl rowOrderingImpl = (RowOrderingImpl)rowOrdering;
        rowOrderingImpl.ordering.clear();
        rowOrderingImpl.currentColumnOrdering = null;
        rowOrderingImpl.unorderedOptimizables.clear();
        for (n = 0; n < this.unorderedOptimizables.size(); ++n) {
            rowOrderingImpl.unorderedOptimizables.add(this.unorderedOptimizables.get(n));
        }
        rowOrderingImpl.alwaysOrderedOptimizables.clear();
        for (n = 0; n < this.alwaysOrderedOptimizables.size(); ++n) {
            rowOrderingImpl.alwaysOrderedOptimizables.add(this.alwaysOrderedOptimizables.get(n));
        }
        for (n = 0; n < this.ordering.size(); ++n) {
            ColumnOrdering columnOrdering = this.ordering.get(n);
            rowOrderingImpl.ordering.add(columnOrdering.cloneMe());
            if (columnOrdering != this.currentColumnOrdering) continue;
            rowOrderingImpl.rememberCurrentColumnOrdering(n);
        }
        rowOrderingImpl.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            rowOrderingImpl.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int n) {
        this.currentColumnOrdering = this.ordering.get(n);
    }

    public String toString() {
        String string = null;
        return string;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        for (int i = 0; i < this.unorderedOptimizables.size(); ++i) {
            Optimizable optimizable2 = this.unorderedOptimizables.get(i);
            if (optimizable2 == optimizable) continue;
            return true;
        }
        return false;
    }
}

