/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final Set<?> stopWords;
    private static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORD_FILE_COMMENT = "//";
    private final Version matchVersion;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SmartChineseAnalyzer(Version matchVersion) {
        this(matchVersion, true);
    }

    public SmartChineseAnalyzer(Version matchVersion, boolean useDefaultStopWords) {
        this.stopWords = useDefaultStopWords ? DefaultSetHolder.DEFAULT_STOP_SET : Collections.EMPTY_SET;
        this.matchVersion = matchVersion;
    }

    public SmartChineseAnalyzer(Version matchVersion, Set stopWords) {
        this.stopWords = stopWords == null ? Collections.EMPTY_SET : stopWords;
        this.matchVersion = matchVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new SentenceTokenizer(reader);
        result = new WordTokenFilter((TokenStream)result);
        result = new PorterStemFilter((TokenStream)result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords, false);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new SentenceTokenizer(reader);
            streams.filteredTokenStream = new WordTokenFilter((TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new PorterStemFilter(streams.filteredTokenStream);
            if (!this.stopWords.isEmpty()) {
                streams.filteredTokenStream = new StopFilter(this.matchVersion, streams.filteredTokenStream, this.stopWords, false);
            }
        } else {
            streams.tokenStream.reset(reader);
            streams.filteredTokenStream.reset();
        }
        return streams.filteredTokenStream;
    }

    private static final class SavedStreams {
        Tokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static CharArraySet loadDefaultStopWordSet() throws IOException {
            return CharArraySet.unmodifiableSet((CharArraySet)WordlistLoader.getWordSet((Reader)IOUtils.getDecodingReader(SmartChineseAnalyzer.class, (String)SmartChineseAnalyzer.DEFAULT_STOPWORD_FILE, (Charset)IOUtils.CHARSET_UTF_8), (String)SmartChineseAnalyzer.STOPWORD_FILE_COMMENT, (Version)Version.LUCENE_CURRENT));
        }

        static {
            try {
                DEFAULT_STOP_SET = DefaultSetHolder.loadDefaultStopWordSet();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

