/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.noop.NoopMeter;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMeters;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MeterKey;
import reactor.netty.internal.util.MapUtils;
import reactor.util.annotation.Nullable;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    final ConcurrentMap<String, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<String, DistributionSummary>();
    final ConcurrentMap<String, DistributionSummary> dataSentCache = new ConcurrentHashMap<String, DistributionSummary>();
    final ConcurrentMap<String, Counter> errorsCache = new ConcurrentHashMap<String, Counter>();
    final ConcurrentMap<MeterKey, Timer> connectTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> tlsHandshakeTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> addressResolverTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<String, LongAdder> totalConnectionsCache = new ConcurrentHashMap<String, LongAdder>();
    final LongAdder totalConnectionsAdder = new LongAdder();
    final String name;
    final String protocol;

    public MicrometerChannelMetricsRecorder(String name, String protocol) {
        this.name = name;
        this.protocol = protocol;
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataReceivedCache, address, key -> MicrometerChannelMetricsRecorder.filter(DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit(ChannelMeters.DATA_RECEIVED.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address}).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataSentCache, address, key -> MicrometerChannelMetricsRecorder.filter(DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit(ChannelMeters.DATA_SENT.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address}).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Counter c = MapUtils.computeIfAbsent(this.errorsCache, address, key -> MicrometerChannelMetricsRecorder.filter(Counter.builder((String)(this.name + ".errors")).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address}).register(Metrics.REGISTRY)));
        if (c != null) {
            c.increment();
        }
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.getTlsHandshakeTimer(this.name + ".tls.handshake.time", address, status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    public final Timer getTlsHandshakeTimer(String name, String address, String status) {
        MeterKey meterKey = new MeterKey(null, address, null, status);
        return MapUtils.computeIfAbsent(this.tlsHandshakeTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.getConnectTimer(this.name + ".connect.time", address, status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    final Timer getConnectTimer(String name, String address, String status) {
        MeterKey meterKey = new MeterKey(null, address, null, status);
        return MapUtils.computeIfAbsent(this.connectTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.getResolveAddressTimer(this.name + ".address.resolver", address, status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    public final Timer getResolveAddressTimer(String name, String address, String status) {
        MeterKey meterKey = new MeterKey(null, address, null, status);
        return MapUtils.computeIfAbsent(this.addressResolverTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordServerConnectionOpened(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.increment();
        }
    }

    @Override
    public void recordServerConnectionClosed(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.decrement();
        }
    }

    @Nullable
    protected static <M extends Meter> M filter(M meter) {
        if (meter instanceof NoopMeter) {
            return null;
        }
        return meter;
    }

    public String name() {
        return this.name;
    }

    public String protocol() {
        return this.protocol;
    }

    @Nullable
    private LongAdder getTotalConnectionsAdder(SocketAddress serverAddress) {
        String address = Metrics.formatSocketAddress(serverAddress);
        return MapUtils.computeIfAbsent(this.totalConnectionsCache, address, key -> {
            Gauge gauge = MicrometerChannelMetricsRecorder.filter(Gauge.builder((String)(this.name + ".connections.total"), (Object)this.totalConnectionsAdder, LongAdder::longValue).tags(new String[]{ChannelMeters.ConnectionsTotalMeterTags.URI.asString(), this.protocol, ChannelMeters.ConnectionsTotalMeterTags.LOCAL_ADDRESS.asString(), address}).register(Metrics.REGISTRY));
            return gauge != null ? this.totalConnectionsAdder : null;
        });
    }
}

