/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import com.github.fge.lambdas.Throwing;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.jdkim.DKIMSigner;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.mailets.CRLFOutputStream;
import org.apache.james.jdkim.mailets.HeaderSkippingOutputStream;
import org.apache.james.jdkim.mailets.MimeMessageHeaders;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class DKIMSign
extends GenericMailet {
    private String signatureTemplate;
    private PrivateKey privateKey;
    private boolean forceCRLF;

    private String getSignatureTemplate() {
        return this.signatureTemplate;
    }

    private PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void init() throws MessagingException {
        this.signatureTemplate = this.getInitParameter("signatureTemplate");
        Optional privateKeyPassword = this.getInitParameterAsOptional("privateKeyPassword");
        this.forceCRLF = this.getInitParameter("forceCRLF", true);
        try {
            char[] passphrase = privateKeyPassword.map(String::toCharArray).orElse(null);
            InputStream pem = this.getInitParameterAsOptional("privateKey").map(String::getBytes).map(ByteArrayInputStream::new).map(byteArrayInputStream -> byteArrayInputStream).orElseGet(Throwing.supplier(() -> ClassLoader.getSystemResourceAsStream(this.getInitParameter("privateKeyFilepath"))).sneakyThrow());
            this.privateKey = this.extractPrivateKey(pem, passphrase);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessagingException("Unknown private key algorythm: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidKeySpecException e) {
            throw new MessagingException("PrivateKey should be in base64 encoded PKCS8 (der) format: " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MessagingException("Problem during reading: " + e.getMessage(), (Exception)e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        DKIMSigner signer = new DKIMSigner(this.getSignatureTemplate(), this.getPrivateKey());
        SignatureRecord signRecord = signer.newSignatureRecordTemplate(this.getSignatureTemplate());
        try {
            BodyHasher bhj = signer.newBodyHasher(signRecord);
            MimeMessage message = mail.getMessage();
            MimeMessageHeaders headers = new MimeMessageHeaders(message);
            try {
                FilterOutputStream os = new HeaderSkippingOutputStream(bhj.getOutputStream());
                if (this.forceCRLF) {
                    os = new CRLFOutputStream(os);
                }
                message.writeTo((OutputStream)os);
            }
            catch (IOException e) {
                throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
            }
            finally {
                try {
                    bhj.getOutputStream().close();
                }
                catch (IOException e) {
                    throw new MessagingException("Exception calculating bodyhash: " + e.getMessage(), (Exception)e);
                }
            }
            String signatureHeader = signer.sign((Headers)headers, bhj);
            this.prependHeader(message, signatureHeader);
        }
        catch (PermFailException e) {
            throw new MessagingException("PermFail while signing: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void prependHeader(MimeMessage message, String signatureHeader) throws MessagingException {
        ArrayList prevHeader = Collections.list(message.getAllHeaderLines());
        Collections.list(message.getAllHeaders()).stream().map(Header::getName).forEach(Throwing.consumer(arg_0 -> ((MimeMessage)message).removeHeader(arg_0)).sneakyThrow());
        message.addHeaderLine(signatureHeader);
        prevHeader.forEach(Throwing.consumer(arg_0 -> ((MimeMessage)message).addHeaderLine(arg_0)).sneakyThrow());
    }

    private PrivateKey extractPrivateKey(InputStream rawKey, char[] passphrase) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try (InputStreamReader pemReader = new InputStreamReader(rawKey);){
            KeyPair keyPair;
            JcaPEMKeyConverter converter;
            Object pemObject;
            PEMParser pemParser;
            block14: {
                PrivateKey privateKey;
                pemParser = new PEMParser((Reader)pemReader);
                try {
                    pemObject = pemParser.readObject();
                    converter = new JcaPEMKeyConverter().setProvider("BC");
                    if (!(pemObject instanceof PrivateKeyInfo)) break block14;
                    privateKey = converter.getPrivateKey((PrivateKeyInfo)pemObject);
                }
                catch (Throwable throwable) {
                    try {
                        pemParser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                pemParser.close();
                return privateKey;
            }
            if (pemObject instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)pemObject;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(passphrase);
                keyPair = converter.getKeyPair(pemEncryptedKeyPair.decryptKeyPair(decProv));
            } else {
                keyPair = converter.getKeyPair((PEMKeyPair)pemObject);
            }
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKeySpec privateKeySpec = keyFac.getKeySpec(keyPair.getPrivate(), RSAPrivateCrtKeySpec.class);
            PrivateKey privateKey = keyFac.generatePrivate(privateKeySpec);
            pemParser.close();
            return privateKey;
        }
    }
}

