/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.os;

import java.util.Locale;

public class CpuInfo {
    private static final Locale LOCALE = Locale.ENGLISH;

    public static Cpu determineCpu() {
        String archString = System.getProperty("os.arch");
        if (CpuInfo.equalsIgnoreCase("x86", archString) || CpuInfo.equalsIgnoreCase("i386", archString) || CpuInfo.equalsIgnoreCase("i86pc", archString) || CpuInfo.equalsIgnoreCase("i686", archString)) {
            return Cpu.I386;
        }
        if (CpuInfo.equalsIgnoreCase("x86_64", archString) || CpuInfo.equalsIgnoreCase("amd64", archString)) {
            return Cpu.X86_64;
        }
        if (CpuInfo.equalsIgnoreCase("ppc", archString) || CpuInfo.equalsIgnoreCase("powerpc", archString)) {
            return Cpu.PPC;
        }
        if (CpuInfo.equalsIgnoreCase("ppc64", archString) || CpuInfo.equalsIgnoreCase("powerpc64", archString)) {
            if ("little".equals(System.getProperty("sun.cpu.endian"))) {
                return Cpu.PPC64LE;
            }
            return Cpu.PPC64;
        }
        if (CpuInfo.equalsIgnoreCase("ppc64le", archString) || CpuInfo.equalsIgnoreCase("powerpc64le", archString)) {
            return Cpu.PPC64LE;
        }
        if (CpuInfo.equalsIgnoreCase("s390", archString) || CpuInfo.equalsIgnoreCase("s390x", archString)) {
            return Cpu.S390X;
        }
        if (CpuInfo.equalsIgnoreCase("aarch64", archString)) {
            return Cpu.AARCH64;
        }
        if (CpuInfo.equalsIgnoreCase("arm", archString) || CpuInfo.equalsIgnoreCase("armv7l", archString)) {
            return Cpu.ARM;
        }
        for (Cpu cpu : Cpu.values()) {
            if (!CpuInfo.equalsIgnoreCase(cpu.name(), archString)) continue;
            return cpu;
        }
        return Cpu.UNKNOWN;
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2) || s1.toUpperCase(LOCALE).equals(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).equals(s2.toLowerCase(LOCALE));
    }

    public static enum Cpu {
        I386,
        X86_64,
        PPC,
        PPC64,
        PPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        MIPS32,
        ARM,
        AARCH64,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }
}

