/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RolloverResponse
extends AcknowledgedResponseBase {
    private final Map<String, Boolean> conditions;
    private final boolean dryRun;
    private final String newIndex;
    private final String oldIndex;
    private final boolean rolledOver;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<RolloverResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverResponse::setupRolloverResponseDeserializer);

    private RolloverResponse(Builder builder) {
        super(builder);
        this.conditions = ApiTypeHelper.unmodifiableRequired(builder.conditions, (Object)this, "conditions");
        this.dryRun = ApiTypeHelper.requireNonNull(builder.dryRun, this, "dryRun");
        this.newIndex = ApiTypeHelper.requireNonNull(builder.newIndex, this, "newIndex");
        this.oldIndex = ApiTypeHelper.requireNonNull(builder.oldIndex, this, "oldIndex");
        this.rolledOver = ApiTypeHelper.requireNonNull(builder.rolledOver, this, "rolledOver");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static RolloverResponse of(Function<Builder, ObjectBuilder<RolloverResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Boolean> conditions() {
        return this.conditions;
    }

    public final boolean dryRun() {
        return this.dryRun;
    }

    public final String newIndex() {
        return this.newIndex;
    }

    public final String oldIndex() {
        return this.oldIndex;
    }

    public final boolean rolledOver() {
        return this.rolledOver;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.conditions)) {
            generator.writeKey("conditions");
            generator.writeStartObject();
            for (Map.Entry<String, Boolean> item0 : this.conditions.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().booleanValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("dry_run");
        generator.write(this.dryRun);
        generator.writeKey("new_index");
        generator.write(this.newIndex);
        generator.writeKey("old_index");
        generator.write(this.oldIndex);
        generator.writeKey("rolled_over");
        generator.write(this.rolledOver);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    protected static void setupRolloverResponseDeserializer(ObjectDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::conditions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.booleanDeserializer()), "conditions");
        op.add(Builder::dryRun, JsonpDeserializer.booleanDeserializer(), "dry_run");
        op.add(Builder::newIndex, JsonpDeserializer.stringDeserializer(), "new_index");
        op.add(Builder::oldIndex, JsonpDeserializer.stringDeserializer(), "old_index");
        op.add(Builder::rolledOver, JsonpDeserializer.booleanDeserializer(), "rolled_over");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RolloverResponse> {
        private Map<String, Boolean> conditions;
        private Boolean dryRun;
        private String newIndex;
        private String oldIndex;
        private Boolean rolledOver;
        private Boolean shardsAcknowledged;

        public final Builder conditions(Map<String, Boolean> map) {
            this.conditions = Builder._mapPutAll(this.conditions, map);
            return this;
        }

        public final Builder conditions(String key, Boolean value) {
            this.conditions = Builder._mapPut(this.conditions, key, value);
            return this;
        }

        public final Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder newIndex(String value) {
            this.newIndex = value;
            return this;
        }

        public final Builder oldIndex(String value) {
            this.oldIndex = value;
            return this;
        }

        public final Builder rolledOver(boolean value) {
            this.rolledOver = value;
            return this;
        }

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RolloverResponse build() {
            this._checkSingleUse();
            return new RolloverResponse(this);
        }
    }
}

