/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.events.RegistrationKey;

public class RoutingKeyConverter {
    private static final char SEPARATOR = ':';
    private final Map<String, RegistrationKey.Factory> factories;

    @VisibleForTesting
    static RoutingKeyConverter forFactories(RegistrationKey.Factory ... factories) {
        return new RoutingKeyConverter((Set<RegistrationKey.Factory>)ImmutableSet.copyOf((Object[])factories));
    }

    @Inject
    public RoutingKeyConverter(Set<RegistrationKey.Factory> factories) {
        this.factories = (Map)factories.stream().collect(ImmutableMap.toImmutableMap(factory -> factory.forClass().getSimpleName(), f -> f));
    }

    RegistrationKey toRegistrationKey(String routingKey) {
        int separatorIndex = routingKey.indexOf(58);
        if (separatorIndex < 0) {
            throw new IllegalArgumentException("Routing key needs to match the 'classFQDN:value' pattern");
        }
        String registrationClass = routingKey.substring(0, separatorIndex);
        String value = routingKey.substring(separatorIndex + 1);
        return Optional.ofNullable(this.factories.get(registrationClass)).orElseThrow(() -> new IllegalArgumentException("No factory for " + registrationClass)).fromString(value);
    }

    static class RoutingKey {
        private final Optional<RegistrationKey> registrationKey;

        static RoutingKey empty() {
            return new RoutingKey(Optional.empty());
        }

        static RoutingKey of(RegistrationKey key) {
            return new RoutingKey(Optional.of(key));
        }

        private RoutingKey(Optional<RegistrationKey> registrationKey) {
            this.registrationKey = registrationKey;
        }

        String asString() {
            return this.registrationKey.map(key -> key.getClass().getSimpleName() + ":" + key.asString()).orElse("");
        }
    }
}

