/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.tasks.TaskIdDto;
import org.eclipse.jetty.http.HttpHeader;
import spark.Request;
import spark.Response;
import spark.Route;

public interface TaskFromRequest {
    public Task fromRequest(Request var1) throws Exception;

    default public Route asRoute(TaskManager taskManager) {
        return new TaskRoute(this, taskManager);
    }

    public static class TaskRoute
    implements Route {
        private final TaskFromRequest taskFromRequest;
        private final TaskManager taskManager;

        TaskRoute(TaskFromRequest taskFromRequest, TaskManager taskManager) {
            this.taskFromRequest = taskFromRequest;
            this.taskManager = taskManager;
        }

        public TaskIdDto handle(Request request, Response response) throws Exception {
            Task task = this.taskFromRequest.fromRequest(request);
            TaskId taskId = this.taskManager.submit(task);
            response.status(201);
            response.header(HttpHeader.LOCATION.asString(), "/tasks/" + taskId.asString());
            return new TaskIdDto(taskId.getValue());
        }
    }
}

