/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ActiveMQThreadPoolExecutor
extends ThreadPoolExecutor {
    private int maxPoolSize;

    public ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadFactory factory) {
        this(coreSize, maxSize, keep, keepUnits, new ThreadPoolQueue(), factory);
    }

    private ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadPoolQueue myQueue, ThreadFactory factory) {
        super(coreSize, Integer.MAX_VALUE, keep, keepUnits, (BlockingQueue<Runnable>)myQueue, factory);
        this.maxPoolSize = maxSize;
        myQueue.setExecutor(this);
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxSize) {
        this.maxPoolSize = maxSize;
    }

    private static class ThreadPoolQueue
    extends LinkedBlockingQueue<Runnable> {
        private ActiveMQThreadPoolExecutor executor = null;
        private static final AtomicIntegerFieldUpdater<ThreadPoolQueue> DELTA_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ThreadPoolQueue.class, "threadTaskDelta");
        private volatile int threadTaskDelta = 0;

        private ThreadPoolQueue() {
        }

        public void setExecutor(ActiveMQThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public boolean offer(Runnable runnable) {
            boolean retval = false;
            if ((this.threadTaskDelta > 0 || this.executor.getPoolSize() >= this.executor.getMaximumPoolSize()) && (retval = super.offer(runnable))) {
                DELTA_UPDATER.decrementAndGet(this);
            }
            return retval;
        }

        @Override
        public Runnable take() throws InterruptedException {
            DELTA_UPDATER.incrementAndGet(this);
            Runnable runnable = null;
            try {
                Runnable runnable2 = runnable = (Runnable)super.take();
                return runnable2;
            }
            finally {
                if (runnable == null) {
                    DELTA_UPDATER.decrementAndGet(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable poll(long arg0, TimeUnit arg2) throws InterruptedException {
            DELTA_UPDATER.incrementAndGet(this);
            Runnable runnable = null;
            try {
                runnable = (Runnable)super.poll(arg0, arg2);
            }
            finally {
                if (runnable == null) {
                    DELTA_UPDATER.decrementAndGet(this);
                }
            }
            return runnable;
        }
    }
}

