/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonNumber;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;

abstract class JsonNumberImpl
implements JsonNumber {
    private int hashCode;

    JsonNumberImpl() {
    }

    static JsonNumber getJsonNumber(int num) {
        return new JsonIntNumber(num);
    }

    static JsonNumber getJsonNumber(long num) {
        return new JsonLongNumber(num);
    }

    static JsonNumber getJsonNumber(BigInteger value) {
        return new JsonBigDecimalNumber(new BigDecimal(value));
    }

    static JsonNumber getJsonNumber(double value) {
        return new JsonBigDecimalNumber(BigDecimal.valueOf(value));
    }

    static JsonNumber getJsonNumber(BigDecimal value) {
        return new JsonBigDecimalNumber(value);
    }

    public boolean isIntegral() {
        return this.bigDecimalValue().scale() == 0;
    }

    public int intValue() {
        return this.bigDecimalValue().intValue();
    }

    public int intValueExact() {
        return this.bigDecimalValue().intValueExact();
    }

    public long longValue() {
        return this.bigDecimalValue().longValue();
    }

    public long longValueExact() {
        return this.bigDecimalValue().longValueExact();
    }

    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue().toBigInteger();
    }

    public BigInteger bigIntegerValueExact() {
        return this.bigDecimalValue().toBigIntegerExact();
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.NUMBER;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.bigDecimalValue().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonNumber)) {
            return false;
        }
        JsonNumber other = (JsonNumber)obj;
        return this.bigDecimalValue().equals(other.bigDecimalValue());
    }

    public String toString() {
        return this.bigDecimalValue().toString();
    }

    private static final class JsonBigDecimalNumber
    extends JsonNumberImpl {
        private final BigDecimal bigDecimal;

        JsonBigDecimalNumber(BigDecimal value) {
            this.bigDecimal = value;
        }

        public BigDecimal bigDecimalValue() {
            return this.bigDecimal;
        }

        public Number numberValue() {
            return this.bigDecimalValue();
        }
    }

    private static final class JsonLongNumber
    extends JsonNumberImpl {
        private final long num;
        private BigDecimal bigDecimal;

        JsonLongNumber(long num) {
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return (int)this.num;
        }

        @Override
        public int intValueExact() {
            return Math.toIntExact(this.num);
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        public Number numberValue() {
            return this.num;
        }

        @Override
        public String toString() {
            return Long.toString(this.num);
        }
    }

    private static final class JsonIntNumber
    extends JsonNumberImpl {
        private final int num;
        private BigDecimal bigDecimal;

        JsonIntNumber(int num) {
            this.num = num;
        }

        @Override
        public boolean isIntegral() {
            return true;
        }

        @Override
        public int intValue() {
            return this.num;
        }

        @Override
        public int intValueExact() {
            return this.num;
        }

        @Override
        public long longValue() {
            return this.num;
        }

        @Override
        public long longValueExact() {
            return this.num;
        }

        @Override
        public double doubleValue() {
            return this.num;
        }

        public BigDecimal bigDecimalValue() {
            BigDecimal bd = this.bigDecimal;
            if (bd == null) {
                this.bigDecimal = bd = new BigDecimal(this.num);
            }
            return bd;
        }

        public Number numberValue() {
            return this.num;
        }

        @Override
        public String toString() {
            return Integer.toString(this.num);
        }
    }
}

