/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import org.jgroups.logging.Log;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class DefaultThreadFactory
implements ThreadFactory {
    protected final String baseName;
    protected final boolean createDaemons;
    protected final boolean use_numbering;
    protected short counter;
    protected boolean includeClusterName;
    protected String clusterName;
    protected boolean includeLocalAddress;
    protected String address;
    protected boolean use_fibers;
    protected Log log;

    public DefaultThreadFactory(String baseName, boolean createDaemons) {
        this(baseName, createDaemons, false);
    }

    public DefaultThreadFactory(String baseName, boolean createDaemons, boolean use_numbering) {
        this.baseName = baseName;
        this.createDaemons = createDaemons;
        this.use_numbering = use_numbering;
    }

    @Override
    public void setPattern(String pattern) {
        if (pattern != null) {
            this.includeClusterName = pattern.contains("c");
            this.includeLocalAddress = pattern.contains("l");
        }
    }

    @Override
    public void setIncludeClusterName(boolean includeClusterName) {
        this.includeClusterName = includeClusterName;
    }

    @Override
    public void setClusterName(String channelName) {
        this.clusterName = channelName;
    }

    @Override
    public void setAddress(String address) {
        this.address = address;
    }

    public boolean useFibers() {
        return this.use_fibers;
    }

    public <T extends DefaultThreadFactory> T useFibers(boolean f) {
        this.use_fibers = f;
        return (T)this;
    }

    public <T extends DefaultThreadFactory> T log(Log l) {
        this.log = l;
        return (T)this;
    }

    @Override
    public Thread newThread(Runnable r, String name) {
        return this.newThread(r, name, null, null);
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(r, this.baseName, null, null);
    }

    protected Thread newThread(Runnable r, String name, String addr, String cluster_name) {
        String thread_name = this.getNewThreadName(name, addr, cluster_name);
        if (this.use_fibers) {
            return Util.createFiber(r, name);
        }
        Thread retval = this.use_fibers ? Util.createFiber(r, name) : new Thread(r, thread_name);
        retval.setDaemon(this.createDaemons);
        return retval;
    }

    @Override
    public void renameThread(String base_name, Thread thread) {
        this.renameThread(base_name, thread, this.address, this.clusterName);
    }

    public void renameThread(String base_name, Thread thread, String addr, String cluster_name) {
        String thread_name = this.getThreadName(base_name, thread, addr, cluster_name);
        if (thread_name != null) {
            thread.setName(thread_name);
        }
    }

    public void renameThread(Thread thread) {
        this.renameThread(null, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getThreadName(String base_name, Thread thread, String addr, String cluster_name) {
        if (thread == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : thread.getName());
        if (this.use_numbering) {
            short id;
            DefaultThreadFactory defaultThreadFactory = this;
            synchronized (defaultThreadFactory) {
                id = this.counter = (short)(this.counter + 1);
            }
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress && cluster_name != null) {
            sb.append(",shared=").append(cluster_name);
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        if (this.use_numbering || this.includeClusterName || this.includeLocalAddress) {
            return sb.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNewThreadName(String base_name, String addr, String cluster_name) {
        StringBuilder sb = new StringBuilder(base_name != null ? base_name : "thread");
        if (this.use_numbering) {
            short id;
            DefaultThreadFactory defaultThreadFactory = this;
            synchronized (defaultThreadFactory) {
                id = this.counter = (short)(this.counter + 1);
            }
            sb.append("-").append(id);
        }
        if (cluster_name == null) {
            cluster_name = this.clusterName;
        }
        if (addr == null) {
            addr = this.address;
        }
        if (!this.includeClusterName && !this.includeLocalAddress && cluster_name != null) {
            sb.append(",shared=").append(cluster_name);
            return sb.toString();
        }
        if (this.includeClusterName) {
            sb.append(',').append(cluster_name);
        }
        if (this.includeLocalAddress) {
            sb.append(',').append(addr);
        }
        return sb.toString();
    }
}

