/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.search;

import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;

public class DeletedWithRangeSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final CassandraDeletedMessageDAO dao;

    @Inject
    public DeletedWithRangeSearchOverride(CassandraDeletedMessageDAO dao) {
        this.dao = dao;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return searchQuery.getCriteria().size() == 2 && searchQuery.getCriteria().contains(SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED)) && searchQuery.getCriteria().stream().anyMatch(criterion -> criterion instanceof SearchQuery.UidCriterion) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        SearchQuery.UidCriterion uidArgument = searchQuery.getCriteria().stream().filter(criterion -> criterion instanceof SearchQuery.UidCriterion).map(SearchQuery.UidCriterion.class::cast).findAny().orElseThrow(() -> new RuntimeException("Missing Uid argument"));
        Object[] uidRanges = uidArgument.getOperator().getRange();
        return Flux.fromIterable((Iterable)ImmutableList.copyOf((Object[])uidRanges)).concatMap(range -> this.dao.retrieveDeletedMessage((CassandraId)mailbox.getMailboxId(), MessageRange.range((MessageUid)range.getLowValue(), (MessageUid)range.getHighValue())));
    }
}

