/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class ConnectionPerIpLimitUpstreamHandler
extends SimpleChannelUpstreamHandler {
    private final ConcurrentMap<String, AtomicInteger> connections = new ConcurrentHashMap<String, AtomicInteger>();
    private final int maxConnectionsPerIp;

    public ConnectionPerIpLimitUpstreamHandler(int maxConnectionsPerIp) {
        this.maxConnectionsPerIp = maxConnectionsPerIp;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.maxConnectionsPerIp > 0) {
            InetSocketAddress remoteAddress = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
            String remoteIp = remoteAddress.getAddress().getHostAddress();
            AtomicInteger atomicCount = (AtomicInteger)this.connections.get(remoteIp);
            if (atomicCount == null) {
                atomicCount = new AtomicInteger(1);
                AtomicInteger oldAtomicCount = this.connections.putIfAbsent(remoteIp, atomicCount);
                if (oldAtomicCount != null) {
                    atomicCount = oldAtomicCount;
                }
            } else {
                Integer count = atomicCount.incrementAndGet();
                if (count > this.maxConnectionsPerIp) {
                    ctx.getChannel().close();
                }
            }
        }
        super.channelOpen(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        InetSocketAddress remoteAddress;
        String remoteIp;
        AtomicInteger atomicCount;
        if (this.maxConnectionsPerIp > 0 && (atomicCount = (AtomicInteger)this.connections.get(remoteIp = (remoteAddress = (InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress().getHostAddress())) != null) {
            atomicCount.decrementAndGet();
        }
        super.channelClosed(ctx, e);
    }
}

