/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.transport.mailets.delivery.MailboxAppenderImpl;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ToSenderFolder
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToSenderFolder.class);
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private String folder;
    private boolean consume;
    private MailboxAppenderImpl mailboxAppender;

    @Inject
    public ToSenderFolder(UsersRepository usersRepository, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }

    public void service(Mail mail) throws MessagingException {
        if (!mail.getState().equals("ghost")) {
            this.doService(mail);
            if (this.consume) {
                mail.setState("ghost");
            }
        }
    }

    private void doService(Mail mail) throws MessagingException {
        if (mail.hasSender()) {
            MailAddress sender = mail.getMaybeSender().get();
            Username username = this.retrieveUser(sender);
            this.mailboxAppender.append(mail.getMessage(), username, this.folder).block();
            LOGGER.error("Local delivery with ToSenderFolder mailet for mail {} with sender {} in folder {}", new Object[]{mail.getName(), sender, this.folder});
        }
    }

    private Username retrieveUser(MailAddress sender) throws MessagingException {
        try {
            return this.usersRepository.getUsername(sender);
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public void init() throws MessagingException {
        this.folder = this.getInitParameter("folder", "Sent");
        this.consume = this.getInitParameter("consume", false);
        this.mailboxAppender = new MailboxAppenderImpl(this.mailboxManager);
    }

    public String getMailetInfo() {
        return ToSenderFolder.class.getName() + " Mailet";
    }
}

