/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.james.jdkim.DKIMCommon;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.api.Headers;
import org.apache.james.jdkim.api.PublicKeyRecord;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;
import org.apache.james.jdkim.impl.BodyHasherImpl;
import org.apache.james.jdkim.impl.CompoundBodyHasher;
import org.apache.james.jdkim.impl.DNSPublicKeyRecordRetriever;
import org.apache.james.jdkim.impl.Message;
import org.apache.james.jdkim.impl.MultiplexingPublicKeyRecordRetriever;
import org.apache.james.jdkim.tagvalue.PublicKeyRecordImpl;
import org.apache.james.jdkim.tagvalue.SignatureRecordImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DKIMVerifier
extends DKIMCommon {
    private PublicKeyRecordRetriever publicKeyRecordRetriever;

    public DKIMVerifier() {
        this.publicKeyRecordRetriever = new MultiplexingPublicKeyRecordRetriever("dns", new DNSPublicKeyRecordRetriever());
    }

    public DKIMVerifier(PublicKeyRecordRetriever publicKeyRecordRetriever) {
        this.publicKeyRecordRetriever = publicKeyRecordRetriever;
    }

    protected PublicKeyRecord newPublicKeyRecord(String record) {
        return new PublicKeyRecordImpl(record);
    }

    public SignatureRecord newSignatureRecord(String record) {
        return new SignatureRecordImpl(record);
    }

    protected BodyHasherImpl newBodyHasher(SignatureRecord signRecord) throws PermFailException {
        return new BodyHasherImpl(signRecord);
    }

    protected PublicKeyRecordRetriever getPublicKeyRecordRetriever() throws PermFailException {
        return this.publicKeyRecordRetriever;
    }

    public PublicKeyRecord publicKeySelector(List<String> records) throws PermFailException {
        String lastError = null;
        if (records == null || records.isEmpty()) {
            lastError = "no key for signature";
        } else {
            for (String record : records) {
                try {
                    PublicKeyRecord pk = this.newPublicKeyRecord(record);
                    pk.validate();
                    return pk;
                }
                catch (IllegalStateException e) {
                    lastError = "invalid key for signature: " + e.getMessage();
                }
            }
        }
        throw new PermFailException(lastError);
    }

    public static void apply(PublicKeyRecord pkr, SignatureRecord sign) throws PermFailException {
        try {
            if (!pkr.getGranularityPattern().matcher(sign.getIdentityLocalPart()).matches()) {
                throw new PermFailException("inapplicable key identity local=" + sign.getIdentityLocalPart() + " Pattern: " + pkr.getGranularityPattern().pattern(), ((Object)sign.getIdentity()).toString());
            }
            if (!pkr.isHashMethodSupported(sign.getHashMethod())) {
                throw new PermFailException("inappropriate hash for a=" + sign.getHashKeyType() + "/" + sign.getHashMethod(), ((Object)sign.getIdentity()).toString());
            }
            if (!pkr.isKeyTypeSupported(sign.getHashKeyType())) {
                throw new PermFailException("inappropriate key type for a=" + sign.getHashKeyType() + "/" + sign.getHashMethod(), ((Object)sign.getIdentity()).toString());
            }
            if (pkr.isDenySubdomains() && !((Object)sign.getIdentity()).toString().toLowerCase().endsWith(("@" + sign.getDToken()).toLowerCase())) {
                throw new PermFailException("AUID in subdomain of SDID is not allowed by the public key record.", ((Object)sign.getIdentity()).toString());
            }
        }
        catch (IllegalStateException e) {
            throw new PermFailException("Invalid public key: " + e.getMessage(), ((Object)sign.getIdentity()).toString());
        }
    }

    public PublicKeyRecord publicRecordLookup(SignatureRecord sign) throws TempFailException, PermFailException {
        PublicKeyRecord key = null;
        FailException lastTempFailure = null;
        PermFailException lastPermFailure = null;
        Iterator<CharSequence> rlm = sign.getRecordLookupMethods().iterator();
        while (key == null && rlm.hasNext()) {
            CharSequence method = rlm.next();
            try {
                PublicKeyRecordRetriever pkrr = this.getPublicKeyRecordRetriever();
                List<String> records = pkrr.getRecords(method, ((Object)sign.getSelector()).toString(), ((Object)sign.getDToken()).toString());
                PublicKeyRecord tempKey = this.publicKeySelector(records);
                DKIMVerifier.apply(tempKey, sign);
                key = tempKey;
            }
            catch (TempFailException tf) {
                lastTempFailure = tf;
            }
            catch (PermFailException pf) {
                lastPermFailure = pf;
            }
        }
        if (key == null) {
            if (lastTempFailure != null) {
                if (sign != null) {
                    lastTempFailure.setRelatedRecordIdentity(((Object)sign.getIdentity()).toString());
                }
                throw lastTempFailure;
            }
            if (lastPermFailure != null) {
                if (sign != null) {
                    lastPermFailure.setRelatedRecordIdentity(((Object)sign.getIdentity()).toString());
                }
                throw lastPermFailure;
            }
            throw new PermFailException("no key for signature [unexpected condition]", ((Object)sign.getIdentity()).toString());
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SignatureRecord> verify(InputStream is) throws IOException, FailException {
        try {
            Message message;
            try {
                message = new Message(is);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new PermFailException("Mime parsing exception: " + e1.getMessage(), e1);
            }
            try {
                List<SignatureRecord> list = this.verify(message, message.getBodyInputStream());
                message.dispose();
                return list;
            }
            catch (Throwable throwable) {
                message.dispose();
                throw throwable;
            }
        }
        finally {
            is.close();
        }
    }

    public BodyHasher newBodyHasher(Headers messageHeaders) throws FailException {
        List<String> fields = messageHeaders.getFields("DKIM-Signature");
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        HashMap<String, BodyHasherImpl> bodyHashJobs = new HashMap<String, BodyHasherImpl>();
        Hashtable<String, FailException> signatureExceptions = new Hashtable<String, FailException>();
        for (String signatureField : fields) {
            try {
                int pos = signatureField.indexOf(58);
                if (pos > 0) {
                    SignatureRecord signatureRecord;
                    String v = signatureField.substring(pos + 1, signatureField.length());
                    try {
                        signatureRecord = this.newSignatureRecord(v);
                        signatureRecord.validate();
                    }
                    catch (IllegalStateException e) {
                        throw new PermFailException("Invalid signature record: " + e.getMessage(), e);
                    }
                    if (signatureRecord.getSignatureTimestamp() != null) {
                        long signedTime = signatureRecord.getSignatureTimestamp();
                        long elapsed = System.currentTimeMillis() / 1000L - signedTime;
                        if (elapsed < -94608000L) {
                            throw new PermFailException("Signature date is more than " + -elapsed / 31536000L + " years in the future.");
                        }
                        if (elapsed < -7776000L) {
                            throw new PermFailException("Signature date is more than " + -elapsed / 2592000L + " months in the future.");
                        }
                        if (elapsed < -259200L) {
                            throw new PermFailException("Signature date is more than " + -elapsed / 86400L + " days in the future.");
                        }
                        if (elapsed < -10800L) {
                            throw new PermFailException("Signature date is more than " + -elapsed / 3600L + " hours in the future.");
                        }
                        if (elapsed < -180L) {
                            throw new PermFailException("Signature date is more than " + -elapsed / 60L + " minutes in the future.");
                        }
                        if (elapsed < 0L) {
                            throw new PermFailException("Signature date is " + elapsed + " seconds in the future.");
                        }
                    }
                    PublicKeyRecord publicKeyRecord = this.publicRecordLookup(signatureRecord);
                    List<CharSequence> signedHeadersList = signatureRecord.getHeaders();
                    byte[] decoded = signatureRecord.getSignature();
                    this.signatureVerify(messageHeaders, signatureRecord, decoded, publicKeyRecord, signedHeadersList);
                    BodyHasherImpl bhj = this.newBodyHasher(signatureRecord);
                    bodyHashJobs.put(signatureField, bhj);
                    continue;
                }
                throw new PermFailException("unexpected bad signature field");
            }
            catch (TempFailException e) {
                signatureExceptions.put(signatureField, e);
            }
            catch (PermFailException e) {
                signatureExceptions.put(signatureField, e);
            }
            catch (RuntimeException e) {
                signatureExceptions.put(signatureField, new PermFailException("Unexpected exception processing signature", e));
            }
        }
        if (bodyHashJobs.isEmpty()) {
            if (signatureExceptions.size() > 0) {
                throw this.prepareException(signatureExceptions);
            }
            throw new PermFailException("Unexpected condition with " + fields);
        }
        return new CompoundBodyHasher(bodyHashJobs, signatureExceptions);
    }

    public List<SignatureRecord> verify(Headers messageHeaders, InputStream bodyInputStream) throws IOException, FailException {
        BodyHasher bh = this.newBodyHasher(messageHeaders);
        if (bh == null) {
            return null;
        }
        CompoundBodyHasher cbh = this.validateBodyHasher(bh);
        DKIMCommon.streamCopy(bodyInputStream, cbh.getOutputStream());
        return this.verify(cbh);
    }

    public List<SignatureRecord> verify(BodyHasher bh) throws FailException {
        if (bh == null) {
            return null;
        }
        CompoundBodyHasher cbh = this.validateBodyHasher(bh);
        return this.verify(cbh);
    }

    private CompoundBodyHasher validateBodyHasher(BodyHasher bh) throws PermFailException {
        if (!(bh instanceof CompoundBodyHasher)) {
            throw new PermFailException("Unexpected BodyHasher type: this is not generated by DKIMVerifier!");
        }
        CompoundBodyHasher cbh = (CompoundBodyHasher)bh;
        return cbh;
    }

    private List<SignatureRecord> verify(CompoundBodyHasher compoundBodyHasher) throws FailException {
        LinkedList<SignatureRecord> verifiedSignatures = new LinkedList<SignatureRecord>();
        for (BodyHasherImpl bhj : compoundBodyHasher.getBodyHashJobs().values()) {
            byte[] computedHash = bhj.getDigest();
            byte[] expectedBodyHash = bhj.getSignatureRecord().getBodyHash();
            if (!Arrays.equals(expectedBodyHash, computedHash)) {
                compoundBodyHasher.getSignatureExceptions().put("DKIM-Signature:" + bhj.getSignatureRecord().toString(), new PermFailException("Computed bodyhash is different from the expected one"));
                continue;
            }
            verifiedSignatures.add(bhj.getSignatureRecord());
        }
        if (verifiedSignatures.isEmpty()) {
            throw this.prepareException(compoundBodyHasher.getSignatureExceptions());
        }
        return verifiedSignatures;
    }

    private FailException prepareException(Map<String, FailException> signatureExceptions) {
        if (signatureExceptions.size() == 1) {
            return signatureExceptions.values().iterator().next();
        }
        return new PermFailException("found " + signatureExceptions.size() + " invalid signatures");
    }

    private void signatureVerify(Headers h, SignatureRecord sign, byte[] decoded, PublicKeyRecord key, List<CharSequence> headers) throws PermFailException {
        try {
            PublicKey publicKey;
            Signature signature = Signature.getInstance(((Object)sign.getHashMethod()).toString().toUpperCase() + "with" + ((Object)sign.getHashKeyType()).toString().toUpperCase());
            try {
                publicKey = key.getPublicKey();
            }
            catch (IllegalStateException e) {
                throw new PermFailException("Invalid Public Key: " + e.getMessage(), e);
            }
            signature.initVerify(publicKey);
            DKIMVerifier.signatureCheck(h, sign, headers, signature);
            if (!signature.verify(decoded)) {
                throw new PermFailException("Header signature does not verify");
            }
        }
        catch (InvalidKeyException e) {
            throw new PermFailException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PermFailException(e.getMessage(), e);
        }
        catch (SignatureException e) {
            throw new PermFailException(e.getMessage(), e);
        }
    }
}

